 import java.net.*;

 public class urltest{

    public static boolean IsURLOk(URL url){

      /* should have no leading/trailing LWS
       * expedite the typical case by assuming it has
       * form "HTTP/1.x <WS> 2XX <mumble>"
       */
      int ind;
      try {  

	
	URLConnection urlc = url.openConnection();
    
	String resp = urlc.getHeaderField(0);
   
	ind = resp.indexOf(' ');
	while(resp.charAt(ind) == ' ')
	  ind++;
	int responseCode = Integer.parseInt(resp.substring(ind, ind + 3));
      
	System.out.println("responseCode = " + responseCode);
	return !( ((responseCode >= 400) && (responseCode <= 415)) || 
		  ((responseCode >= 500) && (responseCode <= 505))
		  );
            
      } catch (Exception e) { 
	return false;
      }

    }

   public static String makeGoodUrl(String str){

     String retstr;

     retstr = str.replace( '\\', '/' );
    
     int ind = 0;
     
     if (retstr.startsWith("http")){
       ind = 6;
     }

     if (retstr.indexOf("//" , ind) != -1){
       char c[] = retstr.toCharArray();
       int len = retstr.length();
       for(int i = ind; i < len; i++){
	
	 if (c[i] == '/'){
	   int j = i+1;

	   while( (j < len) && (c[j] == '/') ){
	     j = j+1;
	   }
	   if (j > (i+1)){
	     for(int k = i+1 , l = j; l < len; l++ , k++){
	       c[k] = c[l];
	     }
	     len = len - (j-i-1);
	   }
	 }
	 retstr = new String(c , 0 , len);
       }
     }
     return retstr; 
   }
	   
     
     
 

    public static void main(String argv[]){
      
      try{
	
	System.out.println("\n\n\nBefore makeGoodUrl****************************************\n\n");
	URL foo = new URL("http://perfwww/spec/java/run/spec/benchmarks/_213_javac/input/" + "\\java/lang/Object.class");
	System.out.println("Return value for " + foo + " = " + IsURLOk(foo));


	URL moo = new URL("http://perfwww/spec/java/run/spec/benchmarks/_213_javac/input/" + "java/lang/Object.class");
	System.out.println("Return value for " + moo + " = " + IsURLOk(moo));

	URL doo = new URL("http://perfwww/spec/java/run/spec/benchmarks/_213_javac/input/" + "/java/lang/Object.class");
	System.out.println("Return value for " + doo + " = " + IsURLOk(doo));

	URL goo = new URL("http://fuzja:90/specjava/spec/benchmarks/_213_javac/input/" + "\\java/lang/Object.class");
	System.out.println("Return value for " + goo + " = " + IsURLOk(goo));
	
	URL boo = new URL("http://fuzja:90/specjava/spec/benchmarks/_213_javac/input/" + "java/lang/Object.class");
	System.out.println("Return value for " + boo + " = " + IsURLOk(boo));

	URL poo = new URL("http://fuzja:90/specjava/spec/benchmarks/_213_javac/input/" + "/java/lang/Object.class");
	System.out.println("Return value for " + poo + " = " + IsURLOk(poo));

	
	System.out.println("\n\n\nAfter makeGoodUrl****************************************\n\n");
	URL foo1 = new URL(makeGoodUrl("http://perfwww/spec/java/run/spec/benchmarks/_213_javac/input/" + 
				      "\\java/lang/Object.class"));
	System.out.println("Return value for " + foo1 + " = " + IsURLOk(foo1));


	URL moo1 = new URL(makeGoodUrl("http://perfwww/spec/java/run/spec/benchmarks/_213_javac/input/" + 
				      "java/lang/Object.class"));
	System.out.println("Return value for " + moo1 + " = " + IsURLOk(moo1));

	URL doo1 = new URL(makeGoodUrl("http://perfwww/spec/java/run/spec/benchmarks/_213_javac/input/" + 
				      "/java/lang/Object.class"));
	System.out.println("Return value for " + doo1 + " = " + IsURLOk(doo1));

	URL goo1 = new URL(makeGoodUrl("http://fuzja:90/specjava/spec/benchmarks/_213_javac/input/" + 
				      "\\java/lang/Object.class"));
	System.out.println("Return value for " + goo1 + " = " + IsURLOk(goo1));
	
	URL boo1 = new URL(makeGoodUrl("http://fuzja:90/specjava/spec/benchmarks/_213_javac/input/" + 
				      "java/lang/Object.class"));
	System.out.println("Return value for " + boo1 + " = " + IsURLOk(boo1));

	URL poo1 = new URL(makeGoodUrl("http://fuzja:90/specjava/spec/benchmarks/_213_javac/input/" + 
				      "/java/lang/Object.class"));
	System.out.println("Return value for " + poo1 + " = " + IsURLOk(poo1));
	
	System.out.println("\n\n\nSome more test cases****************************************\n\n");
	String hoo = "http:///goo/moo/";
	System.out.println("hoo = " + hoo + " makeGoodUrl(hoo) = " + makeGoodUrl(hoo));
	
	hoo = "http:////goo/moo/";
	System.out.println("hoo = " + hoo + " makeGoodUrl(hoo) = " + makeGoodUrl(hoo));	

	hoo = "////goo/moo/";
	System.out.println("hoo = " + hoo + " makeGoodUrl(hoo) = " + makeGoodUrl(hoo));	

	hoo = "//goo/\\moo/";
	System.out.println("hoo = " + hoo + " makeGoodUrl(hoo) = " + makeGoodUrl(hoo));	
	
	hoo = "//goo//moo/";
	System.out.println("hoo = " + hoo + " makeGoodUrl(hoo) = " + makeGoodUrl(hoo));	

	hoo = "//goo//moo///";
	System.out.println("hoo = " + hoo + " makeGoodUrl(hoo) = " + makeGoodUrl(hoo));	
	
	hoo = "//goo//moo////";
	System.out.println("hoo = " + hoo + " makeGoodUrl(hoo) = " + makeGoodUrl(hoo));	
	
	hoo = "///goo/////moo////";
	System.out.println("hoo = " + hoo + " makeGoodUrl(hoo) = " + makeGoodUrl(hoo));	

	hoo = "///goo////\\\\moo////";
	System.out.println("hoo = " + hoo + " makeGoodUrl(hoo) = " + makeGoodUrl(hoo));	
   
      }catch(Exception e){
	System.out.println("Exception occured! " + e);
	e.printStackTrace();
      }

    }

 }
      
      
