package spec.io;

import java.util.*;
import java.net.*;
import spec.harness.*;


public class FileInputStream extends java.io.InputStream{
  


  //************************* Static variables****************************//
  // Constants
  private static final int LENGTH_ERROR = -1;

  // Cache variables
  private static Hashtable filecache = new Hashtable();
  private static Vector openedInputStreams = new Vector();

  public  static boolean debug = false;
  public  static boolean testing = false;
  public  static int numofCloses = 0;

  // How and whether to retry http operations
  private static int nRetry = 5;		// times to try
  private static int retryDelay = 5000;		// milliseconds
  private static int totalRetries = 0;		// count over all benchmarks
  private static boolean use11net = true;	// use 1.1 API instead of

  // IO Stats variables
  private static int num_open_files = 0;
  private static int num_files_used = 0;
  private static int num_cached_files = 0;
  private static int size_cached_data = 0;
  private static int total_num_of_byte_reads_from_cache = 0;
  private static int total_num_of_byte_reads_from_file = 0;
  private static int total_num_of_byte_reads_from_url = 0;
  private static int num_cache_hits = 0;
  private static int num_cache_misses = 0;
  private static long IOtime =0;
  private static long Cachingtime = 0;
  //********************** End Static variables****************************//

 

  //************************* Static methods******************************//

  // Cache methods
  
  public static void clearCache(){
    filecache = new Hashtable();
    num_cached_files = 0;
    size_cached_data = 0;
    num_cache_hits = 0;
    num_cache_misses = 0;  
  }


  
  public static void closeAll() throws java.io.IOException{

    Enumeration all_opened_in_streams = openedInputStreams.elements();
    if(debug) {
        System.out.println("Close all called");
    }

    while(all_opened_in_streams.hasMoreElements()){
      
      try{
	java.io.InputStream in = (java.io.InputStream)all_opened_in_streams.nextElement();
	in.close();
	num_open_files--;
      }catch(NoSuchElementException e){
      }
    }

  }
  

  // IO Stats methods

  /*
   * could be useful in debugging
  public static String getListCachedFiles(){
      StringBuffer buf = new StringBuffer();
      for (Enumeration e = filecache.keys(); e.hasMoreElements(); ){
	  buf.append ((String)(e.nextElement()));
	  buf.append (",");
      }
      return buf.toString();
  }
   */

  public static int getNumOpenFiles(){
    return num_open_files;
  }
  public static int getNumUsedFiles(){
    return num_files_used;
  }
  public static int getNumCachedFiles(){
    return num_cached_files;
  }
  public static int getCachedDataSize(){
    return size_cached_data;
  }
  public static int getNumCacheByteReads(){
    return total_num_of_byte_reads_from_cache;
  }
  public static int getNumFileByteReads(){
    return total_num_of_byte_reads_from_file;
  }
  public static int getNumUrlByteReads(){
    return total_num_of_byte_reads_from_url;
  }
  public static int getNumCacheHits(){
    return num_cache_hits;
  }
  public static int getNumCacheMisses(){
    return  num_cache_misses;
  }
  public static long getIOtime(){
    return IOtime;
  }
  public static long getCachingtime(){
    return Cachingtime;
  }
  public static int getTotalRetries(){
    return totalRetries;
  }
  
  public static void clearIOStats(){
    num_files_used = 0;
    total_num_of_byte_reads_from_cache = 0;
    total_num_of_byte_reads_from_file = 0;
    total_num_of_byte_reads_from_url = 0;
    IOtime = 0;
    Cachingtime = 0;
  }


  // Highly volatile method (lots of problems)
  public static boolean IsURLOk(URL url){

    /* should have no leading/trailing LWS
     * expedite the typical case by assuming it has
     * form "HTTP/1.x <WS> 2XX <mumble>"
     */
    int ind;
    try {  
      
      URLConnection urlc = url.openConnection();
    
      String resp = urlc.getHeaderField(0);

      if( resp == null ) {
//	  System.out.println( "resp == NULL in IsURLOk" );
	  return true;	   
      }
         
      ind = resp.indexOf(' ');
      while(resp.charAt(ind) == ' ')
	ind++;
      int responseCode = Integer.parseInt(resp.substring(ind, ind + 3));
      
      if (debug){
	System.out.println("responseCode = " + responseCode);
      }

      return !( ((responseCode >= 400) && (responseCode <= 415)) || 
		((responseCode >= 500) && (responseCode <= 505))
		);
            
    } catch (java.io.IOException e) { 
      System.out.println("Exception in IsURLOk " + e );	    
      return false;
    }

  }


  private static String makeGoodUrl(String str){

    String retstr;

    retstr = str.replace( '\\', '/' );
    
    int ind = 0;
     
    if (retstr.startsWith("http")){
      ind = 6;
    }

    if (retstr.indexOf("//" , ind) != -1){
      char c[] = retstr.toCharArray();
      int len = retstr.length();
      for(int i = ind; i < len; i++){
	
	if (c[i] == '/'){
	  int j = i+1;

	  while( (j < len) && (c[j] == '/') ){
	    j = j+1;
	  }
	  if (j > (i+1)){
	    for(int k = i+1 , l = j; l < len; l++ , k++){
	      c[k] = c[l];
	    }
	    len = len - (j-i-1);
	  }
	}
	retstr = new String(c , 0 , len);
      }
    }
    return retstr; 
  }

  //********************** End Static methods****************************//

  

  
  private String my_file_url;
  private java.io.InputStream orig_in;
  
  private int len = 0;
  
  private boolean closed = false;
  private boolean doCache;
  private boolean fromCache = false;
  private boolean fromUrl = false;
  
 
 
  private void collectReadStats(int len){
    
    if (len <= 0){
      return;
    }
    
    if (fromCache){
      total_num_of_byte_reads_from_cache += len;
    }
    else{
      if (fromUrl){
	total_num_of_byte_reads_from_url += len;
      }
      else{
	total_num_of_byte_reads_from_file += len;
      }
    }

  }
    
    
    /**
     * Main class constructor.
     * 
     * Try and find the strange URL open bug by catching any exceptions and calling the
     * System finalizer to try and close the sockets.
     */     
    public FileInputStream(String input_filename) throws java.io.FileNotFoundException,
				    java.net.MalformedURLException , java.io.IOException {
	super();
    
	try {
            construct(input_filename);
	} catch(Exception a) {
	    System.out.println ( "----------------------------------");
	    System.out.println ( "spec.io.FileInputStream: Caught exception in constructor: "+a);
	    System.out.println ( "trying to open: " + input_filename); //wnb
	    System.out.println ( "spec.io.FileInputStream: Attempting recovery with System.runFinalization()");	    
	    System.gc();
	    System.runFinalization();
	    try {
		construct(input_filename);
	    } catch(Exception b){
   		System.out.println ( "----------------------------------");
		System.out.println ( "spec.io.FileInputStream: Caught exception in constructor at second level: "+a);
		if ( !(b instanceof java.io.FileNotFoundException) ) {
		    System.out.println ( "spec.io.FileInputStream: Exiting benchmark");		    
		    printStackTrace(b);
		    throw new spec.harness.StopBenchmarkException( "spec.io.FileInputStream failure" );
		} else {
		    throw (java.io.FileNotFoundException)b;
		}
	    }
	}
    }
    
  private void construct(String input_filename) throws Exception{           
      
	long startTime = System.currentTimeMillis();

	my_file_url = makeGoodUrl(Context.getBasePath() + input_filename);
	
	num_open_files++;
	num_files_used++;

	if (filecache.containsKey(my_file_url)){

	  long cacheStartTime = System.currentTimeMillis();
	
	  doCache = false;    // no need to cache data -- data is already in cache
	  fromCache = true;   // read data from cache
	
	  num_cache_hits++;   // we have a hit

	  if (debug){
	    System.out.println("\n++++++++making InputStream from cached " + my_file_url);
	  }


	  // Get the cached data from the filecache
	  FileCacheData fcd = (FileCacheData)filecache.get(my_file_url);  

	  // Get the length of the data
	  len = fcd.getLength();

	  // Get an inputStream to read data form the cache
	  orig_in = fcd.getInputStream();

	  long cacheEndTime = System.currentTimeMillis();
	  Cachingtime += (cacheEndTime - cacheStartTime);
	}
	else{
	
	  num_cache_misses++;  // we have a miss
	
	  if (debug){
	    System.out.println("\n++++++++Opening InputStream for " + my_file_url);
	  }

	
	  openStream();  // open an inputStream through network or file I/O

		
	  if (spec.harness.Context.isCachedInput()){

	    long cacheStartTime = System.currentTimeMillis();
	 
	    doCache = true;  // we have to cache data

	    // create a new FileCacheData object of size len and put it in the filecache 
	    // with my_file_url as the key
	
	    FileCacheData fcd = new FileCacheData(len);  
	    filecache.put(my_file_url , fcd);
	  
	    size_cached_data += len;
	    num_cached_files++;
	 
	    long cacheEndTime = System.currentTimeMillis();
	    Cachingtime += (cacheEndTime - cacheStartTime);
	  }
	  else{
	    doCache = false;
	  }

	  // Keep track of all the InputStreams opened so far.
	  openedInputStreams.addElement(orig_in);
	
	
	}
      
	long endTime = System.currentTimeMillis();
	long totalTime = endTime - startTime;


	spec.harness.Context.addIOtime(totalTime);
	IOtime += totalTime;
  } 
  
  
  /**
   * Print the stack backtrace to Context.out. If this is an instance of
   * spec.io.PrintStream (it normally will be) then the default validity
   * check value is changed to '1'. This is the code that means all data
   * should be compaired and will ensure that the benchmark fails the 
   * validity check process.
   */
  void printStackTrace(Exception x) {
      spec.io.PrintStream str = (spec.io.PrintStream)spec.harness.Context.out;      
      char save = str.cout.setValidityCheckValue(ValidityCheckOutputStream.ALL);
      x.printStackTrace(spec.harness.Context.out);
      str.cout.setValidityCheckValue(save);	  
  }
  
  private void openStream() throws java.io.FileNotFoundException,
      java.net.MalformedURLException , java.io.IOException{

    if (Context.isNetworkAccess()){
      fromUrl = true;
      URL url = new URL(my_file_url);
      URLConnection urlc = url.openConnection();
      len = urlc.getHeaderFieldInt("content-length", LENGTH_ERROR);
      for (int retry=0; retry < nRetry && len == LENGTH_ERROR; retry++){
        if (urlc instanceof HttpURLConnection)
          ((HttpURLConnection) urlc).disconnect();
        urlc = null;
        System.gc();
        System.runFinalization();
	if (debug)
            System.out.println ("GET failed on " + my_file_url);
        try{
          Thread.sleep (retryDelay);
        }catch (InterruptedException e){}
        urlc = url.openConnection();
        urlc.connect();
        len = urlc.getHeaderFieldInt("content-length", LENGTH_ERROR);
	totalRetries++;
      }
      if (use11net && (urlc instanceof HttpURLConnection)){
	HttpURLConnection urlh = (HttpURLConnection) urlc;
	if (urlh.getResponseCode() != HttpURLConnection.HTTP_OK)
	  throw new java.io.FileNotFoundException( my_file_url +
	    ": " + urlh.getResponseMessage());
      }else{
        if (!IsURLOk(url))
	  throw new java.io.FileNotFoundException( my_file_url );
      }

      if (len == LENGTH_ERROR){
	throw new java.io.IOException("Cannot establish URL content-length");
/*      
	System.out.println("Error getting size of file -- turning off caching");
	spec.harness.Context.setCachedInputFlag(false);
*/	
      }

      if (debug){
	if (len == LENGTH_ERROR){
	  if (urlc == null){
	    System.out.println("urlc is null");
	  }
	  else{
	    System.out.println("urlc = " + urlc);
	  }
	}
	System.out.println("++++++++spec.io.FileInputStream url len = " + len);
      }

      try{
	orig_in = urlc.getInputStream();
      }catch(java.io.IOException ioe){
	System.out.println("Error trying to get an inputStream from url connection " + urlc);
	throw ioe;
      }

    }else{    // NOT (Context.isNetworkAccess())
    
      File file = new File(my_file_url);
      len = (int)file.length();

      if (debug){
	System.out.println("++++++++spec.io.FileInputStream file len = " + len);
      }
      orig_in = new java.io.FileInputStream(my_file_url);
      
    }
  }
	
	
  public FileInputStream(spec.io.File file) throws java.io.FileNotFoundException,
    java.net.MalformedURLException , java.io.IOException{
        this(file.getPath());
  }
  
  public int getContentLength(){
  
    return len;
    
  }
	
  public synchronized int available() throws java.io.IOException{
    
    try{
     
      return orig_in.available();
    
    }catch(java.io.IOException ioe){
      printStackTrace(ioe);
      throw new spec.harness.StopBenchmarkException(ioe.toString());
    }
  }

  public synchronized int read() throws java.io.IOException{
    
    try{
     
      long startTime = System.currentTimeMillis();
    
      int byte_read = orig_in.read();
      if ((doCache) && (byte_read != -1)){
      
	long cacheStartTime = System.currentTimeMillis();
	((FileCacheData)filecache.get(my_file_url)).copyData((byte)byte_read);
	long cacheEndTime = System.currentTimeMillis();
	Cachingtime += (cacheEndTime - cacheStartTime);
      }
    
      long endTime = System.currentTimeMillis();
      long totalTime = endTime - startTime;


      spec.harness.Context.addIOtime(totalTime);
      IOtime += totalTime;
    
      if( debug ){
//        System.out.println("byte_read = " + byte_read);
      }

      collectReadStats(1);
      return byte_read;
    
    }catch(java.io.IOException ioe){
      printStackTrace(ioe);
      throw new spec.harness.StopBenchmarkException(ioe.toString());
    }
  }
  
  public int read(byte b[]) throws java.io.IOException{
  
    try{
      long startTime = System.currentTimeMillis();
   
      int bytes_read = orig_in.read(b);
    
      if ((doCache) && (bytes_read > 0)){

	long cacheStartTime = System.currentTimeMillis();
	((FileCacheData)filecache.get(my_file_url)).copyData(b, 0, bytes_read);
	long cacheEndTime = System.currentTimeMillis();
	Cachingtime += (cacheEndTime - cacheStartTime);
      }
    
      long endTime = System.currentTimeMillis();
      long totalTime = endTime - startTime;


      spec.harness.Context.addIOtime(totalTime);
      IOtime += totalTime;
    
    
      if( debug ){
	System.out.println("bytes_read = " + bytes_read);
      }
 
      collectReadStats(bytes_read);
      return bytes_read;
    }catch(java.io.IOException ioe){
      printStackTrace(ioe);
      throw new spec.harness.StopBenchmarkException(ioe.toString());
    }
  }

  public synchronized int read(byte b[], int off, int len) throws java.io.IOException{
				 
				 
    try{
     
      long startTime = System.currentTimeMillis();
    
      int bytes_read = orig_in.read(b, off, len);
      if ((doCache) && (bytes_read > 0)){
      
	long cacheStartTime = System.currentTimeMillis();
	((FileCacheData)filecache.get(my_file_url)).copyData(b, off, bytes_read);
	long cacheEndTime = System.currentTimeMillis();
	Cachingtime += (cacheEndTime - cacheStartTime);
      }
      long endTime = System.currentTimeMillis();
      long totalTime = endTime - startTime;


      spec.harness.Context.addIOtime(totalTime);
      IOtime += totalTime;
    
    
      if( debug ){
        System.out.println("bytes_read = " + bytes_read);
      }
    
      collectReadStats(bytes_read);
      return bytes_read;
   
    }catch(java.io.IOException ioe){
      printStackTrace(ioe);
      throw new spec.harness.StopBenchmarkException(ioe.toString());
    }
  }
  
  public void close() throws java.io.IOException{
    
    try{
      if (!closed){

	orig_in.close();
	numofCloses ++;
	num_open_files--;
    
	
	if (debug || testing){
	  System.out.println("++++++++Closing InputStream for " + my_file_url + 
	    " " + num_open_files + " " + numofCloses);
	}
     
	closed = true;
       
      }
      else{
	if (debug){
	  System.out.println("++++++++InputStream for " + my_file_url + " has been closed before");
	}
      }
    }catch(java.io.IOException ioe){
      printStackTrace(ioe);
      throw new spec.harness.StopBenchmarkException(ioe.toString());
    } 
    
  }
  
 
  
  public long skip(long n) throws java.io.IOException{
  
    try{
      if (debug){
	System.out.println("++++++++ Skipping " + n + " positions in InputStream for " + my_file_url);
      }

      if (doCache){
	((FileCacheData)filecache.get(my_file_url)).skipPos(n);
      }
      return orig_in.skip(n);
    }catch(java.io.IOException ioe){
      printStackTrace(ioe);
      throw new spec.harness.StopBenchmarkException(ioe.toString());
    } 

  }
  
  protected void finalize() throws java.io.IOException{
    
  //  try{
      if (!closed){

	if (debug || testing ){
	  System.out.println("++++++++Calling close Inside finalize for " + my_file_url );
	}

	this.close();
	
      }
  /*  }catch(java.io.IOException ioe){
      printStackTrace(ioe);
      throw new spec.harness.StopBenchmarkException(ioe.toString());
    }   
  */  
    
  }

}
