/*
 * @(#)SpecialConsoleOutputStream.java
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

package spec.io;
import spec.harness.Context;

/**
 * This class implements a special from of OutputStream that is used to
 * direct console output from Context.out to a special window.
 *
 * @see spec.io.PrintStream
 */ 
public
class ConsoleOutputStream extends java.io.OutputStream {   
    /**
     * Temporary line buffer
     */
    StringBuffer lineBuffer = new StringBuffer(256);
      
   /**
     * Change the validity checking value. This is only for compatability with
     * ValidityCheckOutputStream, 
     * @param v the value (between 0 and 8)
     * @return the value we replaced
     */
    public char setValidityCheckValue(char v) {
	return v;
    }    
     
    /**
     * Writes a byte. 
     * @param b the byte
     * @exception IOException If an I/O error has occurred.
     */
    public void write(int b) throws java.io.IOException {
	/*
	 * Just let old fashoned ASCII through
	 */
	if ((b >= 0x20 && b <= 0x7f) || b == '\t' || b == '\n') {		
	    lineBuffer.append((char)b);
	    if (b == '\n') {
		flush();
	    }
	}
    }

    /**
     * Flushes the stream. This will write any buffered
     * output bytes.
     * @exception IOException If an I/O error has occurred.
     */
    public void flush() throws java.io.IOException {
	Context.appendWindow(lineBuffer.toString());
	lineBuffer = new StringBuffer(256);    
    }

    /**
     * Writes an array of bytes.
     * @param b	the data to be written
     * @exception IOException If an I/O error has occurred.
     */
    public void write(byte b[]) throws java.io.IOException {
	write(b, 0, b.length);
    }

    /**
     * Writes a subarray of bytes.
     * @param b	the data to be written
     * @param off the start offset in the data
     * @param len the number of bytes that are written
     * @exception IOException If an I/O error has occurred.
     */
    public void write(byte b[], int off, int len) throws java.io.IOException {
	for (int i = 0 ; i < len ; i++) {
	    write(b[off + i]);
	}
    }
}