/*
 * @(#)SpecProps.java	1.16 02/04/98
 *
 * Copyright (c) 1997,1998 Sun Microsystems, Inc. All rights reserved.
 *
 * Permission is expressly granted by Sun Microsystems only for short-term and
 * limited distribution within the SPEC member companies for use in
 * preparation of a benchmark suite.
 * 
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 * 
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 * 
 * This source code is provided as is, without any express or implied warranty.
 *
 */

package spec.harness;

import java.awt.*;
import java.io.*;
import java.net.*;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import spec.harness.OrderedProperties;

public class SpecProps extends Frame {

///////////////////////////////////////
//class variable field declarations
///////////////////////////////////////
private final static Color setupColorDefault = Color.white;

///////////////////////////////////////
//instance variable field declarations
///////////////////////////////////////

private Dialog2		    dialog2;
private boolean		    initialFilesRead = false;
private int		    maxRows = 99;
private Properties	    props;
private String		    specDir;
private String		    specFile;
private Properties	    specProps;
private OrderedProperties   title;
private String		    titleFile;
private String		    userFile;
private Color		    setupColor;

///////////////////////////////////////
//constructor declarations
///////////////////////////////////////

/**
Creates a new SPEC properties object, initialized with properties read from
a file or URL "props/spec". The titles of those properties are given in "props/title".
Those files are specified relative to a base directory which is typically the
SPECjava installation directory. The user is given an opportunity to override
the default location of those files through a dialog box.
@param baseDir base directory / URL prefix
*/
public SpecProps (String baseDir){
    this (baseDir, setupColorDefault);
}

/**
Creates a new SPEC properties object as above
@param baseDir base directory / URL prefix
@param setupColor background color of the setup screen
*/
public SpecProps (String baseDir, Color setupColor){
    this (  baseDir,
	    "props/spec",
    	    ((Context.getUserPropFile() == null) ?
    		baseDir + "props/user" :
    		Context.getUserPropFile()
	    ),
	    "props/title",
	    setupColor);
}

/**
Creates a new SPEC properties object, initialized with properties and titles
read from files as above.
@param baseDir base directory / URL prefix
@param specFileName Default name of file with inital properties specified by SPEC. Path name is relative to baseDir
@param userFileName full URL of file with inital properties specified by user
@param titleFileName Default name of file with property titles. Path name is relative to baseDir
*/
public SpecProps (String baseDir, String specFileName, String userFileName,
    String titleFileName, Color setupColor)
{
    specDir = baseDir;
    specFile = specFileName;
    userFile = userFileName;
    titleFile = titleFileName;
    this.setupColor = setupColor;

    Properties userProps = getProperties(userFile);
    specProps = merge(specDir + specFile, userProps);
    title = getOrderedProperties(specDir + titleFile);
   
    props = (Properties) specProps.clone();
    try{
	String osName = System.getProperty("os.name");
	String osArch = System.getProperty("os.arch");

	props.put("spec.java.version",System.getProperty("java.version"));
	props.put("spec.java.vendor.url",System.getProperty("java.vendor.url"));
	props.put("spec.java.vendor",System.getProperty("java.vendor"));
	/* Netscape security manager doesn't allow us to read this non-critical property
	   Just omit it for now unless we find a way to catch security exceptions
	props.put("user.name",System.getProperty("user.name"));
	*/
    }catch (SecurityException e){
	 // disallowed system properties just aren't set
    }
    try{
	String s = props.getProperty("spec.initial.maxRows");
	if (s != null)
	    maxRows = Integer.parseInt (s);
    }catch (NumberFormatException e){
	// retain default value as initialized
    }
}

///////////////////////////////////////
//class method declarations
///////////////////////////////////////

/*
return an array of strings representing keys for user editable properties
*/

private String[] getEditable(){
    Vector names = new Vector(50);
    for (int i=0; i<title.size(); i++){
	String key = (String) title.keyAt(i);
	if (! (key.startsWith("spec.initial.") || key.endsWith(".ro")))
            names.addElement(key);
    }
    String[] editable = new String[names.size()];
    for (int i=0; i<editable.length; i++)
        editable[i] = (String) names.elementAt(i);
    return editable;
}

private static Properties getProperties (String urlString){
    Properties p = new TestProperties();
//spec.harness.Context.out.println( "Loading " +  urlString );   
    loadPropertyFile(p, urlString);
    return p;
}

private static OrderedProperties getOrderedProperties (String urlString){
    OrderedProperties p = new OrderedProperties();
//spec.harness.Context.out.println( "Loading " +  urlString );     
    loadPropertyFile(p, urlString);
    return p;
}

private static void loadPropertyFile(Properties p, String urlString){

    if( urlString == null ) {
	spec.harness.Context.out.println( "Null urlString" );	
	return;
    }
	

    try{
    	URL url = new URL(urlString);
	boolean ok = true;

	int ind = urlString.indexOf("http:" , 0);
//spec.harness.Context.out.println( urlString + "=" + ind);	
	if( ind == 0) {
	    ok = spec.io.FileInputStream.IsURLOk( url );
	}
	
	if( ok ) {	
	    InputStream str = url.openStream();
	    if( str == null ) {
		spec.harness.Context.out.println( "InputStream in loadPropertyFile is null" );
	    } else {   	    
        	p.load( new BufferedInputStream( str ) );
	    }
	} else {
	    spec.harness.Context.out.println( "Could not open URL " + urlString );
	}
	
	
    }catch (Exception e){
        spec.harness.Context.out.println("Error loading property file " + urlString + " : " + e);
//	e.printStackTrace( spec.harness.Context.out );
    }
}

private static Properties merge(Properties primary, Properties secondary){
    Properties p = (Properties) secondary.clone();
    for (Enumeration e = primary.propertyNames(); e.hasMoreElements();){
        String name = (String) e.nextElement();
        String value = primary.getProperty(name,"");
        p.put(name,value);
    }
    return p;
}

private static Properties merge(String primary, Properties secondary){
    return merge (getProperties(primary), secondary);
}

/*
private static Properties merge(Properties primary, String secondary){
    return merge (primary, getProperties(secondary));
}

private static Properties merge(String primary, String secondary){
    return merge (getProperties(primary), getProperties(secondary));
}
*/

///////////////////////////////////////
//instance method declarations
///////////////////////////////////////

/**
 Get the property value associated with the key.
 @param key key value
 @return property value (may be null if property does not exist)
 Note that both key and value are Strings, not general Objects
 @see java.util.Hashtable#get
 */
public String get (String key){
    return (String) props.get(key);
}

/**
 Get the property value associated with the key,
 or if there is none then return the supplied default value
 @param key key value
 @param def default value
 @return property value or def if property does not exist
 */
public String get (String key, String def){
    String s = (String) props.get(key);
    if (s == null)
	return def;
    else
	return s;
}

/**
 Get the title property value associated with the key.
 @param key key value
 @return property value (may be null if property does not exist)
 Note that both key and value are Strings, not general Objects
 @see java.util.Hashtable#get
 */
public String getTitle (String key){
    return (String) title.get(key);
}


public boolean isSetup(){
    if (dialog2 == null)
	return false;
    else
	return dialog2.statusOK;
}

public void list (PrintStream out){
    props.list (out);
}

public boolean parametersChosen(){
    return true; 
}


public void put (String key, String value){
//spec.harness.Context.out.println( "SpecProps PUT >>>" + key + "=" + value + "<<<" );
    props.put (key, value);
}

public void setup(){
    if (! initialFilesRead){   
//	props = merge(get("spec.generic.platform") ,props);  //nukeplatform
//	props = merge(get("spec.initial.platform") ,props);  //nukeplatform
	props = merge(get("spec.initial.clientFile"),props);
	props = merge(get("spec.initial.serverFile"),props);
	props = merge(specProps,props);
	initialFilesRead = true;
    }
    if (dialog2 == null)
	dialog2 = new Dialog2 ("edit reporting fields",
	    title, props, getEditable(), 30, maxRows, setupColor);
    dialog2.show();
}

public String toString(){
    StringBuffer buf = new StringBuffer();
    for (Enumeration e = props.keys(); e.hasMoreElements();){
        String name = (String) e.nextElement();
        String value = (String) props.get(name);
	if (value == null) value = "";
	char[] chars = value.toCharArray();
        buf.append (name + "=");
	for (int i=0; i < chars.length; i++)
	    if (chars[i] == '\n')
		buf.append ("\\n");
	    else
		buf.append (chars[i]);
	buf.append ('\n');
//spec.harness.Context.out.println( "SpecProps >>>" + name + "=" + value + "<<<" );
    }
    return buf.toString();
}

// End class SpecProps
}


class TestProperties extends Properties {
    public Object put( Object key, Object value ) {
	String k = (String)key;
	if( !k.startsWith( "spec." ) ) {
//	     spec.harness.Context.out.println( "TestProperties: Funny entry Ignored >>>" + key + "=" + value + "<<<" );  
	     return null;	     
	} else {	
//	    spec.harness.Context.out.println( "TestProperties PUT >>>" + key + "=" + value + "<<<" );    
	    return super.put( key, value );
	}
    }
}

