/*
 * @(#)ProgramRunner.java	1.44 02/20/98
 *
 * Copyright (c) 1997,1998 Sun Microsystems, Inc. All rights reserved.
 *
 * Permission is expressly granted by Sun Microsystems only for short-term and
 * limited distribution within the SPEC member companies for use in
 * preparation of a benchmark suite.
 * 
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 * 
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 * 
 * This source code is provided as is, without any express or implied warranty.
 *
 * Modification suggested by Don McCauley - IBM 02/18/98
 * Do System.runFinalization() to ensure opportunity to unload classes
 * Flagged DWM 
 *
 */

package spec.harness;

import java.util.*;

public class ProgramRunner extends Thread {

    public static int ThreadPriority = 3;
    
    public static boolean createValidityCheckFiles = false;
    
    String        className;
    String[]      args;   
    boolean       autoRun; 
    BenchmarkDone parent;
    char          defaultValidityCheckValue;
    int           percentTimes100;
    int           automin;
    int           automax;
    int           autodelay;
    boolean       autogc;
    boolean       checksum;

      
    // Put any classes into this Hashtable that might be loaded on a second run
    // of a benchmark. ByteArrayInputStream is such a case. It is use in
    // spec.io.FileInputStream	             
	     
    static Hashtable classCache = new Hashtable();    
    
    static {    	
	try {
	    Class clazz;
  	    clazz = Class.forName( "java.io.ByteArrayInputStream" );
	    classCache.put( "java.io.ByteArrayInputStream", clazz );
  	    clazz = Class.forName( "spec.io.FileInputStream" );
	    classCache.put( "spec.io.FileInputStream", clazz );  
  	    clazz = Class.forName( "spec.io.PrintStream" );
	    classCache.put( "spec.io.PrintStream", clazz );  
  	    clazz = Class.forName( "spec.io.ValidityCheckOutputStream" );
	    classCache.put( "spec.io.ValidityCheckOutputStream", clazz );  
	} catch( ClassNotFoundException x ) {}
    }
    
    // This variable is used to stop a class being reloaded if it is run twice.

    static Class     lastClass     = null; 
    static String    lastClassName = "";

    public ProgramRunner( 
        String		className, 
	String[]	args, 
	boolean		autoRun, 
	BenchmarkDone	parent, 
	char		defaultValidityCheckValue,
	int		percentTimes100,
	int		automin,
	int		automax,
	int		autodelay,
	boolean		autogc,
	boolean		checksum
    ){
	this.className                 = className;
        this.args                      = args;        
	this.autoRun                   = autoRun;
        this.parent                    = parent;
	this.defaultValidityCheckValue = defaultValidityCheckValue;
	this.percentTimes100           = percentTimes100;
        this.automin		       = automin;
        this.automax		       = automax;
        this.autodelay		       = autodelay;
        this.autogc		       = autogc;
        this.checksum		       = checksum;
    }

    
    public void run() {
        setPriority( ThreadPriority );
        runBenchmark();
    }

    public void stopBenchmark(){
	Context.out.println ("Program runner received stop message");
	if (parent != null)
	    parent.benchmarkDone( className, null );
	stop();
    }

    void runBenchmark() {
    
	Properties results = null;
	
        if( className == null ) {
	    Context.out.println( "No class selected in runBenchmark" );
	} else { 	
	    // The following should cause the last class run to be flushed from the cache if
	    // it is not the one we are about to run.	
	    if( !className.equals( lastClassName ) ) {
		lastClass = null;
		lastClassName = "";
		spec.io.FileInputStream.clearCache();
	    }
	
	    results =  runBenchmark2();    
	}	    
	
	try { spec.io.FileInputStream.closeAll(); } catch( java.io.IOException x ) {}
	
	if( parent != null ) {
            parent.benchmarkDone( className, results );		
	}
    }

    Properties runBenchmark2() { 		
	boolean valid = false;
	long startTime;
	String fullName = "spec.benchmarks."+className+".Main";	
	Properties results  = new Properties();	    
	int speed = Context.getSpeed();
	int intersperse = 0;
	if (speed == 100)
	    intersperse = 10;
	else if (speed == 10)
	    intersperse = 1;
	try {
	    System.gc();
	    System.runFinalization();   /* DWM */
	    startTime = System.currentTimeMillis();
	    Class clazz = Class.forName( fullName );		
	    if( clazz == null ) {
	        Context.out.println( "Could not load class " + fullName );
		return null;
	    }
	    lastClassName = className;
	    lastClass     = clazz;
            Object prog   = clazz.newInstance();
	    if( (prog instanceof SpecBenchmark) == false ) {
		Context.out.println( fullName +
		    " does not implement the SpecBenchmark interface" );
		return null;
	    }
	    Context.out.print( "Caching " +
		(Context.isCachedInput() ? "On" : "Off") );
	    Context.out.print( " Speed = " + speed );
	    if( autoRun ) {
	        Context.out.println( " Auto run mode " );
	    }
	    Context.out.print( "\n" );
	    Context.out.println( "======= " + className + " Starting =======");
	    Context.setBenchmarkRelPath ((new String(
		fullName.toCharArray(),0,fullName.lastIndexOf(".")+1)).
		    replace('.','/') );   
	    long lastTime = Long.MAX_VALUE/10000;		 
	    for (int run = 0 ;; run++) {
		String pref = "spec.results." + className + ".run" + run;
                Context.out.println("Run "+run+" start. " +
                    "Total memory="+Runtime.getRuntime().totalMemory()+
                    " free memory=" + Runtime.getRuntime().freeMemory());
                results.put( pref + ".stats.TotalMemoryStart" ,
                    ""+Runtime.getRuntime().totalMemory() );            
                results.put( pref + ".stats.FreeMemoryStart" ,
                    ""+Runtime.getRuntime().freeMemory() );                 
		long time = runOnce (prog, run, startTime, speed, results);
		valid = (time >= 0);
                String timeStr = ""+(time/1000.0);
                Context.out.println( "======= " + className +
                    " Finished in " + timeStr );
                results.put( pref + ".time" ,  timeStr );       
                results.put( pref + ".speed" , ""+ speed );
		saveResults (pref, results);
		tellParent( className + " - " + timeStr +
		    ((valid)?"":" **NOT VALID**")+"\n" );		
		if( autoRun == false)
		    break;
		// This is an autorun sequence
		// Check for run time threshhold termination of sequence
		if (run >= automin - 1 &&
		    (lastTime*10000)/time < (10000+percentTimes100) ) {
		    break;
		}
		// Check for automax termination of sequence
		if (run >= automax - 1)
		    break;
		/* In an autorun sequence, intersperse untimed executions
		 * of the next smaller size in order to avoid
		 * uncharacteristic optimization feedback from one
		 * execution to the next
		 */
		if (intersperse > 0){
		    long x = runOnce (prog, run, 0, intersperse, results);
	            Context.out.println ("======= " + className + " " +
			intersperse + "% execution - timing ignored");
		}
		startTime = System.currentTimeMillis();
		lastTime  = time;		
	    }//end for (run)
	    if (autogc){
	        Context.out.println ("requested gc");
	        System.gc();
		System.runFinalization();   /* DWM */
	    }
	    pause (autodelay);
        } catch( Throwable e ) {    
	    String msg = ">>>> "+fullName+" exited with exception: " +
		e + " <<<<\n";	        
            Context.out.print( msg );
	    e.printStackTrace( Context.out );   
	    Context.out.println( "" );   
	    tellParent( msg );
	    return null;	    
	}
	return results;
    }

    private long runOnce (Object prog, int run, long startTime,
	int speed, Properties results) throws java.io.IOException
    {
        Context.clearIOtime();
	Context.setSpeed (speed);
        spec.io.FileInputStream.clearIOStats();
        java.io.PrintStream save = null;
        spec.io.ValidityCheckOutputStream vcos = null;
        if (Context.getVerify()) {              
            vcos = new spec.io.ValidityCheckOutputStream(
                className, "validity"+ speed +".dat",
                defaultValidityCheckValue);
            save = Context.out;               
            Context.out = new spec.io.PrintStream(vcos);
        }
        spec.io.FileOutputStream.clearCount();             
        ((SpecBenchmark)prog).harnessMain( args );      
        spec.io.FileOutputStream.printCount(checksum);
        if (Context.getVerify()) {
            Context.out.close();
            Context.out = save; 
        }                                                       
        long time = System.currentTimeMillis() - startTime; 
        if( time == 0 )
            time = 1;
        String statsString = getStatsString( time );            
        Context.out.println( statsString );                 
        Context.out.println("Run "+run+" end. " +
            "Total memory="+Runtime.getRuntime().totalMemory()+
            " free memory=" + Runtime.getRuntime().freeMemory());
	if (Context.getVerify()) {
	    if (createValidityCheckFiles) {
		vcos.createValidityFile();
	    } else if (Context.getVerify()) {
		if (! vcos.validityCheck(results, run))
		    time = -1;
	    }
	}
        return time;
    }

    private void pause (long millis){
	if (millis > 0){
            Context.out.println ("pausing for " + millis + " ms");
	    try{
	        sleep (millis);
	    }catch (InterruptedException e){}
	}
    }

    private void saveResults (String pref, Properties results){
        results.put( pref + ".stats.TotalMemoryEnd" ,
            ""+Runtime.getRuntime().totalMemory() );            
        results.put( pref + ".stats.FreeMemoryEnd"  ,
            ""+Runtime.getRuntime().freeMemory() );     
        results.put( pref + ".stats.cache",
            (Context.isCachedInput() ? "true" : "false"));      
        results.put( pref + ".stats.IOTime" ,
            ""+(spec.io.FileInputStream.getIOtime()/1000.0) );          
        results.put( pref + ".stats.CacheTime" , 
            ""+(spec.io.FileInputStream.getCachingtime()/1000.0) );
        results.put( pref + ".stats.FileOpens" , 
            ""+ spec.io.FileInputStream.getNumUsedFiles() );    
        results.put( pref + ".stats.NumCacheByteReads" , 
            ""+ spec.io.FileInputStream.getNumCacheByteReads() );       
        results.put( pref + ".stats.NumFileByteReads" ,  
            ""+ spec.io.FileInputStream.getNumFileByteReads() );
        results.put( pref + ".stats.NumUrlByteReads" ,   
            ""+ spec.io.FileInputStream.getNumUrlByteReads() );
        results.put( pref + ".stats.NumCachedFiles" , 
            ""+ spec.io.FileInputStream.getNumCachedFiles() );  
        results.put( pref + ".stats.CachedDataSize" , 
            ""+ spec.io.FileInputStream.getCachedDataSize() );  
        results.put( pref + ".stats.NumCacheHits" ,   
            ""+ spec.io.FileInputStream.getNumCacheHits() );    
        results.put( pref + ".stats.NumCacheHits" ,
            ""+ spec.io.FileInputStream.getNumCacheHits() );    
        results.put( pref + ".stats.totalRetries" ,
            ""+ spec.io.FileInputStream.getTotalRetries() );    
    }

    void tellParent( String str ) {
	if( parent != null ) {
            parent.benchmarkPrint( str );
	}
    }


    String getStatsString( long time ) {
	StringBuffer b = new StringBuffer();
	b.append(  "#### General Statistics for this Run ####");
	b.append("\n## Outer time: " + (time/1000.0) + " seconds" );    
	b.append("\n#### IO Statistics for this Run ####");
	b.append("\n## IO time                      : " + (spec.io.FileInputStream.getIOtime()/1000.0) + " seconds" );
	b.append("\n## Caching time                 : " + (spec.io.FileInputStream.getCachingtime()/1000.0) + " seconds" );
	b.append("\n## No. of File opens            : " + spec.io.FileInputStream.getNumUsedFiles() );
	b.append("\n## No. of Byte Reads from cache : " + spec.io.FileInputStream.getNumCacheByteReads() );
	b.append("\n## No. of Byte Reads from File  : " + spec.io.FileInputStream.getNumFileByteReads() );
	b.append("\n## No. of Byte Reads from Url   : " + spec.io.FileInputStream.getNumUrlByteReads() ); 		   
	b.append("\n#### Cumulative Cache Statistics ####");
	b.append("\n## No. of Files cached          : " + spec.io.FileInputStream.getNumCachedFiles() );
	//debug only:   b.append("\n## Files cached                 : " + spec.io.FileInputStream.getListCachedFiles() );
	b.append("\n## Amt. of data cached          : " + spec.io.FileInputStream.getCachedDataSize() + " bytes");
	b.append("\n## No. of Cache hits            : " + spec.io.FileInputStream.getNumCacheHits() );
	b.append("\n## No. of Cache misses          : " + spec.io.FileInputStream.getNumCacheMisses() );
	b.append("\n## No. of HTTP retries          : " + spec.io.FileInputStream.getTotalRetries() );
	b.append("\n");
	return b.toString();
    }


}
