/*
 * @(#)Dialog1.java	1.5 02/04/98
 *
 * Copyright (c) 1997,1998 Sun Microsystems, Inc. All rights reserved.
 *
 * Permission is expressly granted by Sun Microsystems only for short-term and
 * limited distribution within the SPEC member companies for use in
 * preparation of a benchmark suite.
 * 
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 * 
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 * 
 * This source code is provided as is, without any express or implied warranty.
 *
 */

package spec.harness;

import java.awt.*;
import java.util.Properties;

public class Dialog1 extends Frame{

///////////////////////////////////////
//class variable field declarations
///////////////////////////////////////

///////////////////////////////////////
//instance variable field declarations
///////////////////////////////////////
private String title;
private Properties titleProps;
private Properties valueProps;
private String[] propNames;
private TextField[] fields;
private int colWidth;
public boolean statusOK = false;

///////////////////////////////////////
//constructor declarations
///////////////////////////////////////
Dialog1(String s, String base, String msg, Properties t, Properties v, String[] pn, int cw){
    title = s;
    titleProps = t;
    valueProps = v;
    propNames = pn;
    colWidth = cw;
    setLayout(new GridLayout(0,1));
    setBackground (Color.white);
    setTitle(title);
    if (msg != null)
	add (new Label(msg));
    fields = new TextField[propNames.length];
    for (int i=0; i<propNames.length; i++){
        String label = titleProps.getProperty(propNames[i]);
        if (label == null) label = "label " + i + " missing";
        String value = valueProps.getProperty(propNames[i]);
        if (value == null)
	    value = "";
	else
	    value = base + value;
	Panel p = new Panel();
        p.add(new Label(label));
        fields[i] = new TextField(value,colWidth);
        p.add(fields[i]);
	add(p);
    }
    Panel p = new Panel();
    p.add(new Button("OK"));
    p.add(new Button("Cancel"));
    add(p);
    pack();
}

///////////////////////////////////////
//class method declarations
///////////////////////////////////////

///////////////////////////////////////
//instance method declarations
///////////////////////////////////////

public boolean action(Event evt, Object arg){
    if (evt.target instanceof Button){
        if (arg.equals("OK")){
            storeProperties();
	    statusOK = true;
	}
	this.hide();
        return true;
    }
    return super.action(evt,arg);
}

private void storeProperties(){
    for (int i=0; i<propNames.length; i++){
	valueProps.put(propNames[i],fields[i].getText());
    }
}

}

