/*
 * @(#)Context.java	1.25 02/04/98
 *
 * Copyright (c) 1997,1998 Sun Microsystems, Inc. All rights reserved.
 *
 * Permission is expressly granted by Sun Microsystems only for short-term and
 * limited distribution within the SPEC member companies for use in
 * preparation of a benchmark suite.
 * 
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 * 
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 * 
 * This source code is provided as is, without any express or implied warranty.
 *
 */

package spec.harness;

public final class Context{

  static String SpecBasePath = "";
  static boolean NetworkAccess = false;
  static String BasePath = "";
  static int speed = 100;
  static boolean CachedInput = true;
  static boolean batch = false;
  static long IOtime = 0;
  static int num_files_open = 0;
  static int cached_data = 0;
  static int num_cached_files = 0;
  static String userPropFile;
  static boolean verify = true;
  static boolean commandLineMode = false;  
  static ConsoleWindow window;
  
  public static java.io.PrintStream out = System.out;
  
  public static int getValue(String s, int deft) {

      try {
	  return Integer.parseInt(s, 10);
      } catch(NumberFormatException x) {}
            
      return deft;
  }
    
  public static void setupConsoleWindow(){
      window = new ConsoleWindow();
      out = new spec.io.PrintStream(new spec.io.ConsoleOutputStream());
  }
  
  public static void setSpecBasePath(String basepath){

    if (basepath.indexOf("file:" , 0) == 0){
	SpecBasePath = basepath.substring(5);
    }
    else{
        SpecBasePath = basepath;
    }
    
    if (SpecBasePath.indexOf("http:" , 0) == 0){
	NetworkAccess = true;
    } else {
	while (SpecBasePath.charAt(0) == '/' && SpecBasePath.charAt(1) == '/') {
	    SpecBasePath = SpecBasePath.substring(1); 
	}   
    }
    
  }

  public static String getSpecBasePath(){

	return SpecBasePath;     
  }

  public static void addCachedDataSize(int num){
    cached_data += num;
  }
  public static int getCachedDataSize(){
    return cached_data;
  }
  public static void IncrementNumCachedFiles(){
    num_cached_files++;
  }
  public static int getNumCachedFiles(){
    return num_cached_files;
  }
  public static void IncrementNumOpenFiles(){
    num_files_open++;
  }
  public static void DecrementNumOpenFiles(){
    num_files_open--;
  }
  
  public static int getNumOpenFiles(){
    return num_files_open;
  }

  public static void setBenchmarkRelPath(String rpath){
    BasePath = SpecBasePath + rpath;
  }
  
  
  public static void cdInput(){
    if( !BasePath.endsWith( "input/" )) {
	BasePath = BasePath + "input/" ;
    }
  }
  
  public static void setNetworkAccess(boolean flag){

    NetworkAccess = flag;

  }

  public static String getBasePath(){

    return BasePath;

  }

  public static boolean isNetworkAccess(){

    return NetworkAccess;

  }

  
  public static void setSpeed( int n ) {
    speed = n;
  }
  
  
  public static int getSpeed() {
    return speed;
  }
    
  public static void setCachedInputFlag( boolean cif ){
    CachedInput = cif;
  }

  public static void setBatch( boolean b ){
    batch = b;
  }

  public static boolean isBatch(){
    return batch;
  }

  public static void setUserPropFile( String s){
    userPropFile = s;
  }

  public static String getUserPropFile(){
    return userPropFile;
  }

  public static boolean isCachedInput(){
    return CachedInput;
  } 
  
  public static void clearIOtime(){
    IOtime = 0;
  }
  
  public static void addIOtime(long time){
    IOtime = IOtime + time;
  }
  
  public static long getIOtime(){
    return IOtime;
  }
 
    /**
     * Set commandLineMode flag
     */
    public static void setCommandLineMode(boolean value) {
	commandLineMode = value;
    }


    /**
     * Get commandLineMode flag
     */
    public static boolean getCommandLineMode() {
	return commandLineMode;
    }


    /**
     * Set verify flag
     */
    public static void setVerify(boolean value) {
	verify = value;
    }


    /**
     * Get verify flag
     */
    public static boolean getVerify() {
	return verify;
    }
    
          
    /**
     * Start output window
     */
    public static void startOutputWindow() {   
        window.show();	
    }  
        
	    
    /**
     * Stop output window
     */
    public static void stopOutputWindow() {
	window.hide();
    }   
	    
    /**
     * Output to window
     */
    public static void appendWindow(String s) {
	if (window == null) {
	    System.out.print(s);
	} else {	    
	    window.append(s);
	}
    }       
}

