

/*
 * and here's same fix for CR/LF on anagram:Randy 02/18/98
 * .java   Version 1.1 10/23/97 rrh, Kaivalya, Salina
 * SPEC development version @(#)anagram.java    1.13 10/23/97
 *
 * Copyright (c) 1996 IBM Corporation, Inc. All rights reserved.
 *
 * Permission is expressly granted by IBM Corporation only for short-term and
 * limited distribution within the SPEC voting member companies for use in
 * preparation of a benchmark suite.
 *
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 *
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 *
 * This source code is provided as is, without any express or implied warranty.
 *
 *
 * Randy Heisch       IBM Corp. - Austin, TX
 *
 */

//
// Anagram generator 2.0 (using Hashtable instead of binary search)
//
// Randy Heisch 02/09/97
//
package spec.benchmarks._211_anagram;
import spec.harness.*;

import java.io.*;
import java.util.*;



class anagram1
{
String line;
byte[] buffer;

Hashtable dict = new Hashtable();

public byte[] sb;
public String orig_str;   // ssc
int slen;
byte[] tb;
int nstrs;
boolean[] m;
StringBuffer[] tsb;



void read_file(String filename)
   {
   int i, s, e;
   int n = 0, act = 0;
   String str;
   boolean OK;


   tsb = new StringBuffer[16];
   for (i = 0; i < 16; i++)
      tsb[i] = new StringBuffer(256);

   sb = new byte[256];
   m = new boolean[256];

   spec.harness.Context.out.print("Reading dictionary file ... "); spec.harness.Context.out.flush();
   try {

     spec.io.FileInputStream sif = new spec.io.FileInputStream(filename);
     n = sif.getContentLength();

     buffer = new byte[n];

     int bytes_read;
     while ( (bytes_read = sif.read(buffer, act , (n - act))) > 0){
       act = act +  bytes_read;
     }

     sif.close();

     if ( act != n ){
        spec.harness.Context.out.println("ERROR reading input file");
        //System.exit(1);
        return;
     }

   }catch (IOException ioe)
      {
      spec.harness.Context.out.println("ERROR opening/reading input file");
      //System.exit(1);
      };



   s = e = 0;
   while ( (e < n) && (s < n) )
      {
      // Stop at CR or LF - rrh 02/18/98
      while ( (e < n) && (buffer[e] != '\n') && (buffer[e] != '\r') ) e++;

      if ( e < n )
         {
         str = new String(buffer, 0, s, e-s);
         //spec.harness.Context.out.println(str);
         dict.put(str, str);

         // Discard both CR & LF - rrh 02/18/98
         while ( (e < n) && ((buffer[e] == '\n') || (buffer[e] == '\r')) )
            e++;
         s = e;
         }
      }

   spec.harness.Context.out.println("OK");
   }



void pinit(String s)
   {
   int i;

   slen = s.length();

   orig_str = s;   //  ssc

   // Convert/copy string to byte buffer
   s.getBytes(0, s.length(), sb, 0);

   for (i = 0; i < slen; i++)
      if ( sb[i] == 0x20 ) sb[i] = 0;
   }


int permute(int n)    // ssc
   {
   int i, j;
   byte b1, b2;
   boolean t;

   int unique_nstrs = 0;                           // ssc

   if ( n > 0 )
      for (i = 0; i <= n; i++)
         {
         b1 = sb[i];
         b2 = sb[n];
         sb[i] = b2;
         sb[n] = b1;

         unique_nstrs += permute(n-1);

         if ( unique_nstrs > 0 )                  // ssc - stop after 1 match
           return ( unique_nstrs );

         sb[i] = b1;
         sb[n] = b2;
         }
   else
      {
      i = 0;
      nstrs = 0;
      while ( i < slen )
         {
         while ( (sb[i] == 0) && (i < slen) ) i++;

         tsb[nstrs].setLength(slen);

         if ( i < slen )
            {
            j = 0;

            while ( (i < slen) && (sb[i] != 0) )
               {
               tsb[nstrs].setCharAt(j, (char)sb[i]);
               j++;
               i++;
               }

            tsb[nstrs].setLength(j);

            nstrs++;
            }
         }

      if ( false )
         {
         for (i = 0; i < slen; i++)
            if ( sb[i] == 0 )
               spec.harness.Context.out.print(" ");
            else
               spec.harness.Context.out.print((char)sb[i]);

         spec.harness.Context.out.println();
         }


      for (i = 0; ( i < nstrs ) && ( unique_nstrs == 0) ; i++) // ssc - stop after 1 match
         {
         // spec.harness.Context.out.println("   "+tsb[i].toString());

         String compare_str = tsb[i].toString();  // ssc

         if ( dict.get(compare_str) != null )  {      // ssc
//            m[i] = true;

            // if same as original word, don't count it  ... ssc
            if ( compare_str.compareTo( orig_str ) == 0 ) {
              m[i] = false;
            }
            else {
              m[i] = true;
              unique_nstrs ++;
            }
         }
         else
            m[i] = false;
         }

      if ( unique_nstrs > 0 ) {

        for (i = 0, t = true; i < nstrs; i++)
           t &= m[i];

        if ( t )
           {
           for (i = 0; i < nstrs; i++)
              spec.harness.Context.out.print(tsb[i].toString()+" ");

           spec.harness.Context.out.println();
           }

      }


    }

    return ( unique_nstrs);   // ssc

  }





static void gen(String str)
   {
   spec.harness.Context.out.println(str);

   }

}


class fac
{

static long f(int n)
   {
   long r;

   if ( n <= 1 ) return 1;

   r = n * f(n-1);

   return r;
   }
}




public class anagram
{


  public long inst_main(String[] argv) {
    return  run(argv);
  }

  public long run(String[] arg) {
   int i, len, cnt;                  // ssc
   long start, stop, t1, t2;
   // long start_i, stop_i, elapsed_i;
   anagram1 agm = new anagram1();
   long perms;


   if ( arg.length < 1 )
   {
     // spec.harness.Context.out.println("Usage:\n\n   anagram dictionaryfile " +
     //     "\"string\" [\"string\"...]\n");
        return 0;
   }



   start = System.currentTimeMillis();

   System.gc();    // kmd

   agm.read_file(arg[0]);

   spec.harness.Context.out.println("Size of Hash Table : " + agm.dict.size());
   for (int istring=1; istring < arg.length; istring++){
       //start_i = System.currentTimeMillis();
       len = arg[istring].length();
       cnt = 0;                               // ssc
       perms = fac.f(len);
       // spec.harness.Context.out.println(perms+" permutations of "+len
       //          +" characters in \""+arg[istring]+"\"");
       agm.pinit(arg[istring]);
       spec.harness.Context.out.print(arg[istring] + " : ");
       cnt += agm.permute(arg[istring].length()-1);
       //stop_i = System.currentTimeMillis();
       //elapsed_i = stop_i - start_i;

       // print out no anagram if no match found .... ssc
       if ( cnt == 0 ) {
         spec.harness.Context.out.println("NONE");
       }
       else {
       // spec.harness.Context.out.println("Total of " + cnt + " matches");
       }
       // spec.harness.Context.out.println(arg[istring] + " took " +
       //  elapsed_i + " millisecs" );
   }

   stop = System.currentTimeMillis();

   //spec.harness.Context.out.println("Done in "+(stop-start)+"secs");
   //spec.harness.Context.out.println("Done");

   return (stop-start);
   }

}

