package eu.qimpress.samm.visualisation.test;

import static org.junit.Assert.assertEquals;

import java.io.IOException;
import java.util.Map;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.junit.Test;

import de.fzi.gast.core.corePackage;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.staticstructure.StaticstructurePackage;
import eu.qimpress.sourcecodedecorator.FileLevelSourceCodeLink;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorPackage;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;

public class ProxyResolveTest_MM {

	@Test
	public void testProxyResolving(){

		// Obtain a new resource set
		ResourceSet resSet = new ResourceSetImpl();
		
		Map<URI, URI> uriMap = resSet.getURIConverter().getURIMap();
		uriMap.put(URI.createURI("internal_architecture_model.samm_repository"), 
				URI.createFileURI("testdata/model/internal_architecture_model.samm_repository"));
		
		
		// Register the appropriate resource factory to handle all file
		// extensions.
		// MM: you don't need this if you working in the scope of Eclipse platform, however for J-Unit test it is neccessary to initialize factories
		resSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("samm_repository", new XMIResourceFactoryImpl());
		resSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("sourcecodedecorator", new XMIResourceFactoryImpl());
		resSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("gast", new XMIResourceFactoryImpl());
				
		// Register the package to ensure it is available during loading.
		resSet.getPackageRegistry().put(StaticstructurePackage.eNS_URI,	StaticstructurePackage.eINSTANCE);
		resSet.getPackageRegistry().put(SourceCodeDecoratorPackage.eNS_URI,	SourceCodeDecoratorPackage.eINSTANCE);
		resSet.getPackageRegistry().put(corePackage.eNS_URI, corePackage.eINSTANCE);
		
		// Load the SAMM repository resource
		URI uri = URI.createFileURI("testdata/model/internal_architecture_model.samm_repository");
//		Resource resource = resSet.getResource(uri, true);
		Resource resource = new XMIResourceImpl(uri);

		try {
			// MM: null is enough as parameter
			resource.load(null);
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		// Load Source Code Decorator resource
		URI uriDecorator = URI.createFileURI("testdata/model/internal_architecture_model.sourcecodedecorator");
//		Resource resourceDecorator = resSet.getResource(uriDecorator, true);
		Resource resourceDecorator = new XMIResourceImpl(uriDecorator);
		
		try {
			resourceDecorator.load(null);
		} catch (IOException e) {
			e.printStackTrace();
		}
				
		// Get the source code decorator object
		SourceCodeDecoratorRepository scdRep = (SourceCodeDecoratorRepository) resourceDecorator.getContents().get(0);
		FileLevelSourceCodeLink link = scdRep.getFileLevelSourceCodeLink().get(0);
		
		Repository sammRep = (Repository) resource.getContents().get(0);
		PrimitiveComponent pc = (PrimitiveComponent) sammRep.getComponenttype().get(0);
				
		// Should return the name of the component (given in the SAMM repository)
		System.out.println("PrimitiveComponent:" + pc.getId() + ":" + pc.getName());
		System.out.println("SourceCodeDec: " +  link.getComponentType().getId() + ":" + link.getComponentType().getName() + " is Proxy: " + link.getComponentType().eIsProxy());
		// Result: aName
		
		assertEquals( pc.getName(), link.getComponentType().getName());
	}
}
