package eu.qimpress.samm.visualisation.test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.junit.Before;
import org.junit.Test;

import eu.qimpress.samm.staticstructure.CompositeComponent;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.staticstructure.StaticstructureFactory;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;
import eu.qimpress.samm.visualisation.RepositoryVizNode;
import eu.qimpress.samm.visualisation.RepositoryVizSammSwitch;

public class JUnitTest {
	
	private StaticstructureFactory myFac;
	private PrimitiveComponent pc1, pc2, pc3;
	private CompositeComponent cc1, cc2;
	private SubcomponentInstance sub1CC1, sub2CC1, sub1CC2, sub2CC2;
	
	private Repository myRep;
	private RepositoryVizNode root, nodeCC1;
	private RepositoryVizSammSwitch testSwitch;
	
	@Before
	public void init(){
		myFac = StaticstructureFactory.eINSTANCE;
		myRep = myFac.createRepository();
		
		/* primitivies */
		pc1 = myFac.createPrimitiveComponent();
		pc1.setName("PrimitiveComponent1");
		
		pc2 = myFac.createPrimitiveComponent();
		pc2.setName("PrimitiveComponent2");
		
		pc3 = myFac.createPrimitiveComponent();
		pc3.setName("PrimitiveComponent3");
		
		/* composite 1 */
		cc1 = myFac.createCompositeComponent();
		cc1.setName("CompositeComponent1");
		
			sub1CC1 = myFac.createSubcomponentInstance();
			sub1CC1.setRealizedBy(pc1);
			cc1.getSubcomponents().add(sub1CC1);
			
			sub2CC1 = myFac.createSubcomponentInstance();
			sub2CC1.setRealizedBy(pc2);
			cc1.getSubcomponents().add(sub2CC1);
		
		/* composite 2 */
		cc2 = myFac.createCompositeComponent();
		cc2.setName("CompositeComponent2");
		
			sub1CC2 = myFac.createSubcomponentInstance();
			sub1CC2.setRealizedBy(pc3);
			cc2.getSubcomponents().add(sub1CC2);
			
			sub2CC2 = myFac.createSubcomponentInstance();
			sub2CC2.setRealizedBy(cc1);
			cc2.getSubcomponents().add(sub2CC2);
			
		myRep.getComponenttype().add(cc2);
			
		nodeCC1 = new RepositoryVizNode("CompositeComponent1");
		nodeCC1.addChild(new RepositoryVizNode("PrimitiveComponent1"));
		nodeCC1.addChild(new RepositoryVizNode("PrimitiveComponent2"));
			
		root = new RepositoryVizNode("CompositeComponent2");
		root.addChild(new RepositoryVizNode("PrimitiveComponent3"));
		root.addChild(nodeCC1);

		testSwitch = new RepositoryVizSammSwitch(null, null);
	}
	
	@Test
	public void RootCalculation(){
		testSwitch.getDepth(cc2);
		assertEquals(2, (double) testSwitch.getDepth(cc2), 0); 
	}
	
	@Test
	public void CompositeNodeGeneration(){ 	
		RepositoryVizNode result = (RepositoryVizNode) testSwitch.doSwitch(myRep);
		System.out.println(result.getName());
		System.out.println(root.getName());
		assertTrue(result.equals(root));
	
	}

}
