package eu.qimpress.samm.visualisation;

import java.util.ArrayList;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

import eu.qimpress.samm.staticstructure.CompositeComponent;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.staticstructure.util.StaticstructureSwitch;

public class SearchSwitch extends StaticstructureSwitch<ArrayList<String>> {
	private String searchString;
	private ArrayList<String> hits = new ArrayList<String>();
	
	public SearchSwitch(String searchString) {
		super();
		this.searchString = searchString;
	}

	@Override
	public ArrayList<String> caseCompositeComponent(CompositeComponent object) {
		if(object.getName().toLowerCase().contains(searchString)){
			hits.add(object.getId());
		}
		return null;
	}

	@Override
	public ArrayList<String> casePrimitiveComponent(PrimitiveComponent object) {
		if(object.getName().contains(searchString)){
			hits.add(object.getId());
		}
		return null;
	}

	@Override
	public ArrayList<String> caseRepository(Repository object) {
		TreeIterator<EObject> treeIt = object.eAllContents();
		
		//calling all children
		for (; treeIt.hasNext();){
				doSwitch(treeIt.next());
		}
		
		return hits;
	}

	
}
