package eu.qimpress.samm.visualisation;

import java.awt.Color;
import java.awt.Image;
import java.util.ArrayList;

import javax.swing.event.ChangeListener;

import ch.randelshofer.tree.Colorizer;
import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.TreePath2;
import ch.randelshofer.tree.Weighter;
import ch.randelshofer.tree.demo.AbstractNodeInfo;
import ch.randelshofer.tree.demo.RGBColorizer;

public class RepositoryVizNodeInfo extends AbstractNodeInfo {

	private static final int MAX_CLASSES_IN_SINGLE_LINE = 5;

	public RepositoryVizNodeInfo() {    }

    public void init(TreeNode root) {   }

    public String getName(TreePath2<TreeNode> path) {
        RepositoryVizNode node = (RepositoryVizNode) path.getLastPathComponent();
        return node.getName();
    }

    public Color getColor(TreePath2<TreeNode> path) {
    	RepositoryVizNode node = (RepositoryVizNode) path.getLastPathComponent();
    	
    	if(node.isPrimitive())
    		return new Color(180, 200, 254);
    	
    	if(node.isRoot())
    		return new Color(45, 101, 251);
    	
    	return new Color(119, 156, 253);
    }

    public String getTooltip(TreePath2<TreeNode> path) {
    	RepositoryVizNode node = (RepositoryVizNode) path.getLastPathComponent();

        StringBuilder buf = new StringBuilder();
        buf.insert(0, "<html>");
        buf.append("<b>" + node.getName() + "</b>");
                
        int[] childrenInfo = node.getChildInfo();
        
        if(node.isRoot()){
        	
        	buf.append("<br>Primitve Components: ");
        	buf.append(childrenInfo[0]);
        	buf.append("<br>Composite Components: ");
            buf.append(childrenInfo[1]);
        	
        }
        else if (node.getAllowsChildren()) {
        	buf.append("<br>children: ");
        	buf.append(childrenInfo[0] + childrenInfo[1]);
        }
        buf.append("<br>");
        
        ArrayList<String> interfaces = node.getProvidedInterface();
        if(interfaces.size() > 0){
	        buf.append("<u>Provided Interfaces</u>");
	        for (String prov : interfaces) {
	        	buf.append("<br>" + prov + "</br>");
	        }
	        buf.append("<br>");
        }
        
        interfaces = node.getRequiredInterface();
        if(interfaces.size() > 0){
	        buf.append("<u>Required Interfaces</u>");
	        for (String req : interfaces) {
	        	buf.append("<br>" + req + "</br>");
	        }
	        buf.append("<br>");
        }
                
        if(node.getComponentClasses().size() > 0){
	        buf.append("<u>Component Classes</u><br>");
	        int length = 0;
	        for (String componentClass : node.getComponentClasses()) {
	        	buf.append("" + componentClass + " ");
	        	if((++length % MAX_CLASSES_IN_SINGLE_LINE) == 0) {
	        		buf.append("<br>");
	        	}
	        }
        }
        
    	return buf.toString();
    }

    public void addChangeListener(ChangeListener l) {    }

    public void removeChangeListener(ChangeListener l) {    }
    
    public String getWeightFormatted(TreePath2<TreeNode> path) {
        return "";
    }

	@Override
    public Weighter getWeighter() {
        return null;
    }

    @Override
	public Image getImage(TreePath2<TreeNode> arg0) {
		return null;
	}

	@Override
	public long getWeight(TreePath2<TreeNode> path) {
		RepositoryVizNode node = (RepositoryVizNode) path.getLastPathComponent();;
//		int[] childCount = node.getChildInfo(); 
//		return childCount[0] + childCount[1];
		return node.getLinesOfCode();
	}
	
	@Override
	public Colorizer getColorizer() {
        return new RGBColorizer();
    }
}
