package eu.qimpress.samm.visualisation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.eclipse.jface.fieldassist.IContentProposal;

import ch.randelshofer.tree.TreeNode;

public class RepositoryVizNode implements TreeNode, IContentProposal{
	
	private static HashMap<String, RepositoryVizNode> LIST_OF_NODES = new HashMap<String, RepositoryVizNode>();
	
	private ArrayList<TreeNode> children;
	private ArrayList<String> providedInterfaces, requiredInterfaces, componentClasses;
	
	private String name = "", XmiId = "";
	private boolean isPrimitive = false, isRoot = false;
	private int pcNum = 0, ccNum = 0, linesOfCode = 0;
	
	public RepositoryVizNode(String name) {
		this.name = name;
	}
	
	public RepositoryVizNode() {
		providedInterfaces = new ArrayList<String>();
		requiredInterfaces = new ArrayList<String>();
		componentClasses = new ArrayList<String>();
		children = new ArrayList<TreeNode>();
	}

	public HashMap<String, RepositoryVizNode> getLisOfNodes(){
		return LIST_OF_NODES;
	}

	public boolean addChild(TreeNode child){
		 return children.add(child);
	}

	@Override
    public List<TreeNode> children() {
        return children;
    }

	@Override
	public boolean getAllowsChildren() {
		return !isPrimitive;
	}
	
	public String getName(){
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@Override
	public boolean equals(Object obj) {
		RepositoryVizNode testCandiate = (RepositoryVizNode) obj;
		if(this.name.equals(testCandiate.getName()))
			return true;
		return false;
	}

	public void setPrimitive(boolean isPrimitive) {
		this.isPrimitive = isPrimitive;
	}

	public boolean isPrimitive() {
		return isPrimitive;
	}

	public void setChildInfo(int PCNum, int CCNum) {
		this.pcNum = PCNum;
		this.ccNum = CCNum;
	}
	
	public boolean addComponentClasses(String componentClass){
		if(componentClasses.contains(componentClass))
			return false;
		else
			return componentClasses.add(componentClass);
	}	
	
	public boolean addProvidedInterface(String providedInterface){
		if(providedInterfaces.contains(providedInterface))
			return false;
		else
			return providedInterfaces.add(providedInterface);
	}
	
	public boolean addRequiredInterface(String requiredInterface){
		if(requiredInterfaces.contains(requiredInterface))
			return false;
		else
			return requiredInterfaces.add(requiredInterface);
		
	}

	public ArrayList<String> getComponentClasses(){
		return componentClasses;
	}
	
	public ArrayList<String> getProvidedInterface(){
		return providedInterfaces;
	}
	
	public ArrayList<String> getRequiredInterface(){
		return requiredInterfaces;
	}
	
//	TODO: Implement Remover for Interfaces!
	
	/**
	 * @return an array with the number of primitive (index 0) and composite (index 1) components 
	 * 	
	 */
	public int[] getChildInfo() {
		return new int[] {pcNum, ccNum};
	}
	
	public boolean isRoot() {
		return isRoot;
	}

	public void setRoot(boolean isRoot) {
		this.isRoot = isRoot;
	}
	
	public void setXmiId(String xmiId) {
		XmiId = xmiId;
		LIST_OF_NODES.put(xmiId, this);
	}

	public String getXmiId() {
		return XmiId;
	}

	public void setLinesOfCode(int linesOfCode) {
		this.linesOfCode = linesOfCode;
	}

	public int getLinesOfCode() {
		return linesOfCode;
	}

	@Override
	public String getContent() {
		return getName();
	}

	@Override
	public int getCursorPosition() {
		return 0;
	}

	@Override
	public String getDescription() {
		return null;
	}

	@Override
	public String getLabel() {
		return null;
	}
}
