package eu.qimpress.samm.visualisation;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;

import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

import ch.randelshofer.gui.ProgressObserver;
import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.hypertree.HyperTree;
import ch.randelshofer.tree.hypertree.SwingHTView;
import ch.randelshofer.tree.rectmap.RectmapTree;
import ch.randelshofer.tree.rectmap.RectmapView;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.CompositeComponent;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.samm.staticstructure.Repository;


public class RepositoryVizEditor extends EditorPart implements MouseListener, KeyListener {
	
	public static final String ID = "org.somox.feature.repositoryVisualistation.editor"; 
	private RepositoryVizNode myTree, selectedNode;
	private Repository myRep;
	private String vizType = null;
	private JPanel view;
	private RepositoryVizEditorInput input;
	
	private Shell myShell;
	
	public RepositoryVizEditor() {	}

	@Override
	public void doSave(IProgressMonitor monitor) {	}

	@Override
	public void doSaveAs() {	}

	@Override
	public void init(IEditorSite site, IEditorInput input)
			throws PartInitException {

		setSite(site);	setInput(input);
		setPartName(input.getName());
		
		myShell = site.getShell();
		myTree = ((RepositoryVizEditorInput) input).getTree();
		myRep = ((RepositoryVizEditorInput) input).getRepository();
		vizType = ((RepositoryVizEditorInput) input).getActionID();
		this.input = (RepositoryVizEditorInput) input; 
	}

	@Override
	public boolean isDirty() {
		return false;
	}


	@Override
	public boolean isSaveAsAllowed() {
		return false;
	}

	@Override
	public void createPartControl(Composite parent) {
		Composite swtAwtComponent = new Composite(parent, SWT.EMBEDDED);
		java.awt.Frame frame = SWT_AWT.new_Frame(swtAwtComponent);
		RepositoryVizNodeInfo myInfo = new RepositoryVizNodeInfo();
		
		if(vizType.equals("hyper")){
			HyperTree model = new HyperTree(myTree, myInfo);
			
			view = model.getView();
			((SwingHTView )view).setToolTipEnabled(true);
			
			// Adding mouseListener to realize renaming of nodes
			view.addMouseListener(this);
			view.setFocusable(true);
			view.addKeyListener(this);

			frame.add(view);
			
		}
		
		if(vizType.equals("rect")){
			
			//No other constructor available, so using a dummy ProgressObserver
			RectmapTree model = new RectmapTree((TreeNode)myTree, myInfo, new ProgressObserver() {
				
				@Override
				public void setWarning(String arg0) {	}
				
				@Override
				public void setProgress(int arg0) {	}
				
				@Override
				public void setNote(String arg0) {	}
				
				@Override
				public void setModel(BoundedRangeModel arg0) {	}
				
				@Override
				public void setMinimum(int arg0) {	}
				
				@Override
				public void setMaximum(int arg0) {	}
				
				@Override
				public void setIndeterminate(boolean arg0) {	}
				
				@Override
				public void setError(String arg0) {	}
				
				@Override
				public void setDoCancel(Runnable arg0) {	}
				
				@Override
				public void setCancelable(boolean arg0) {	}
				
				@Override
				public boolean isIndeterminate() {	return false;	}
				
				@Override
				public boolean isCompleted() {		return false;	}
				
				@Override
				public boolean isClosed() {			return false;	}
				
				@Override
				public boolean isCanceled() {		return false;	}
				
				@Override
				public String getWarning() {		return null;	}
				
				@Override
				public int getProgress() {			return 0;		}
				
				@Override
				public String getNote() {			return null;	}
				
				@Override
				public BoundedRangeModel getModel() {return null;	}
				
				@Override
				public int getMinimum() {			return 0;		}
				
				@Override
				public int getMaximum() {			return 0;		}
				
				@Override
				public String getError() {			return null;	}
				
				@Override
				public void complete() {	}
				
				@Override
				public void close() {	}
				
				@Override
				public void cancel() {	}
			});
			
			view = new RectmapView(model);
			((RectmapView) view).setMaxDepth(Integer.MAX_VALUE);
			((RectmapView) view).setToolTipEnabled(true);
			frame.add(view);
		}
	}

	@Override
	public void setFocus() {	}
	
	public JPanel getView() {
		return view;
	}

	@Override
	public void mouseClicked(MouseEvent e) {	
		//Waiting for left double click
		if(e.getButton() == MouseEvent.BUTTON1 && e.getClickCount() == 2){
			selectedNode = (RepositoryVizNode) ((SwingHTView) view).getNodeUnderTheMouse(e);
			
			
			if(selectedNode != null && selectedNode.isRoot()){
				final RepositoryVizNode temp;
				Display.getDefault().syncExec(
						new Runnable() {
							public void run(){
								NodeSearchDialog myDia = new NodeSearchDialog(myShell, "Search", "Enter the name of a component", "", null, input);
								myDia.open();
								if(myDia.getReturnCode() == Window.OK)
									center(myDia.getSelectedNode());
								
							}
						});
			}else if(selectedNode != null){
				// creating new thread to call dialog
				Display.getDefault().syncExec(
						new Runnable() {
							public void run(){
								renaming();						
							}
						});
			}
		}
	}

	@Override
	public void mouseEntered(MouseEvent e) {	}

	@Override
	public void mouseExited(MouseEvent e) {		}

	@Override
	public void mousePressed(MouseEvent e) {	}

	@Override
	public void mouseReleased(MouseEvent e) {	}
	
	private void center(RepositoryVizNode node){
		((SwingHTView) view).translateToOrigin(node);
		view.repaint();
		System.out.println(node);
	}
	
	private void renaming(){
		String selectionId = selectedNode.getXmiId();
		ComponentType correspondingEObject = null;
		
		if(!selectedNode.isRoot()){ // PC
			for (EObject comp : myRep.eContents()) {
				if(selectedNode.isPrimitive()){
					if(comp instanceof PrimitiveComponent){
						PrimitiveComponent pcComp = (PrimitiveComponent) comp;
						if(pcComp.getId().equals(selectionId)){
							correspondingEObject = pcComp;
							break;
						}
					}
				}else{ // CC
					if(comp instanceof CompositeComponent){
						CompositeComponent pcComp = (CompositeComponent) comp;
						if(pcComp.getId().equals(selectionId)){
							correspondingEObject = pcComp;
							break;
						}
					}					
				}
			}
		}
		
		if(correspondingEObject == null){
			System.err.println("ERROR: Could not find component in resource");
			return;
		}
		
		InputDialog renameDialog = new InputDialog(myShell, "Rename", "Enter a custom name for the selected component", correspondingEObject.getName(), null);
		renameDialog.open();
		
		// save changed name and redraw graph
		if(renameDialog.getReturnCode() == InputDialog.OK && !renameDialog.getValue().equals("")){
			String newName = renameDialog.getValue();
			correspondingEObject.setName(newName);
			
				// writing changes to the file system
				try {
					myRep.eResource().save(null);
				} catch (IOException e) {
					e.printStackTrace();
				}
				
				// display changes in the visualization 
				selectedNode.setName(newName);
				view.repaint();
		}		
	}

	@Override
	public void keyPressed(KeyEvent e) {
		System.out.println("keyPressed");// TODO Auto-generated method stub
		
	}

	@Override
	public void keyReleased(KeyEvent e) {
		System.out.println("keyReleased");
		
	}

	@Override
	public void keyTyped(KeyEvent e) {
		System.out.println("keyTyped");
		
	}
}
