package eu.qimpress.samm.visualisation;

import java.util.HashMap;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

import eu.qimpress.sourcecodedecorator.ControlFlowLevelSourceCodeLink;
import eu.qimpress.sourcecodedecorator.FileLevelSourceCodeLink;
import eu.qimpress.sourcecodedecorator.InterfaceSourceCodeLink;
import eu.qimpress.sourcecodedecorator.MethodLevelSourceCodeLink;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;
import eu.qimpress.sourcecodedecorator.util.SourceCodeDecoratorSwitch;

/**
 * Generates a HashMap that contains IDs and the corresponding EObjects from the GAST resource.
 * @author Henning Hager
 *
 */
public class RepositoryVizDecoratorSwitch extends SourceCodeDecoratorSwitch<HashMap<String, EObject>> {

	private HashMap<String, EObject> sammIdToFile;
		
	@Override
	public HashMap<String, EObject> caseControlFlowLevelSourceCodeLink(ControlFlowLevelSourceCodeLink object) {
		return null;
	}
	
	

	/**
	 * <code>&lt;fileLevelSourceCodeLink&gt;</code> relates components to files of the GAST resource.
	 */
	@Override
	public HashMap<String, EObject> caseFileLevelSourceCodeLink(FileLevelSourceCodeLink object) {
		if(object.getFile() != null){
			if(object instanceof MethodLevelSourceCodeLink){
				return null;
			}
		sammIdToFile.put(object.getComponentType().getId(), object.getFile());
		}
		return null;
	}
	
	/**
	 * <code>&lt;interfaceSourceCodeLink&gt;</code> relates interface to files of the GAST resource.
	 */
	@Override
	public HashMap<String, EObject> caseInterfaceSourceCodeLink(InterfaceSourceCodeLink object) {
		if(object.getInterface() != null){
			sammIdToFile.put(object.getInterface().getId(), object.getGastClass());
		}
		return null;
	}

	@Override
	public HashMap<String, EObject> caseMethodLevelSourceCodeLink(MethodLevelSourceCodeLink object) {
		return null;
	}

	@Override
	public HashMap<String, EObject> caseSourceCodeDecoratorRepository(SourceCodeDecoratorRepository object) {
		sammIdToFile = new HashMap<String, EObject>();
		TreeIterator<EObject> treeIt = object.eAllContents();
		
		//calling all children
		for (; treeIt.hasNext();) {
				doSwitch(treeIt.next());
		}
		return sammIdToFile;
	}
}
