package eu.qimpress.samm.visualisation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

import eu.qimpress.samm.staticstructure.Repository;

public class NodeSearchDialog extends InputDialog{
	
	private RepositoryVizEditorInput vizData;
	private RepositoryVizNode selectedNode;
	private String textBoxContent;

	public NodeSearchDialog(Shell parentShell, String dialogTitle,
			String dialogMessage, String initialValue, IInputValidator validator, RepositoryVizEditorInput input) {
		super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
		vizData = input;

	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.InputDialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite myDialogArea = (Composite) super.createDialogArea(parent);


		KeyStroke keyStroke;
		try {
			keyStroke = KeyStroke.getInstance("Ctrl+Space");
			// assume that myTextControl has already been created in some way
			ContentProposalAdapter adapter = new ContentProposalAdapter(getText(),
					new TextContentAdapter(),
					new myContentProposalProvider(vizData),
					keyStroke, null);
			adapter.setProposalAcceptanceStyle(ContentProposalAdapter.PROPOSAL_REPLACE);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return myDialogArea;
	}

	public RepositoryVizNode getSelectedNode() {
		String nodeName = getValue();
		Collection<RepositoryVizNode> listOfNodes = vizData.getTree().getLisOfNodes().values();
		for (RepositoryVizNode node : listOfNodes) {
			if(node.getName().equalsIgnoreCase(nodeName)){
				return node;
			}
		}
		return null;	
			
		
		
	}
}
class myContentProposalProvider implements  IContentProposalProvider{
	private RepositoryVizNode vizTree;
	private Repository repository;

	public myContentProposalProvider(RepositoryVizEditorInput data) {
		vizTree = data.getTree();
		repository = data.getRepository();
	}

	@Override
	public IContentProposal[] getProposals(String contents, int position) {
		SearchSwitch mySearchSwitch = new SearchSwitch(contents);
		ArrayList<String> results = mySearchSwitch.doSwitch((EObject) repository);
		
		if(results.size() == 0)
			return new IContentProposal[0];
		
		IContentProposal[] proposals = new IContentProposal[results.size()];
		
		HashMap<String, RepositoryVizNode> listOfNodes = vizTree.getLisOfNodes();
		
		if(results.isEmpty())
			return (IContentProposal[]) listOfNodes.entrySet().toArray();
		for(int i = 0; i < proposals.length; i++){
			proposals[i] = listOfNodes.get(results.get(i)); 
		}
		
		return proposals;
	}
	
}
