package eu.qimpress.samm.visualisation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature.Setting;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.EcoreUtil.ProxyCrossReferencer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;

public class InitRepositoryVisualization implements IObjectActionDelegate {

	private URI selectionURI = null, workspaceUri = URI.createURI(EcorePlugin.getWorkspaceRoot().getLocationURI().toString());
	private Shell shell = null;

	/**
	 * Constructor for Action1.
	 */
	public InitRepositoryVisualization() {
		super();
	}
	
	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		shell = targetPart.getSite().getShell();
	}
	
	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(final IAction action){
		boolean defaultNaming = false;
		
		// Obtain a new resource set
		ResourceSet resSet = new ResourceSetImpl();
		Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("gast", new PerformantXMIResourceFactoryImpl());
		Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("samm_repository", new PerformantXMIResourceFactoryImpl());
		Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("sourcecodedecorator", new PerformantXMIResourceFactoryImpl());
		
		Map<URI, URI> uriMap = resSet.getURIConverter().getURIMap();
		
		// Resources need to be final to be accessed in own threads (jobs)
		final Resource sammResource, decoratorResource;
		URI decoratorUri = null;		
		// Get the resource of the SAMM repository 
		URI sammURI = selectionURI;
		uriMap.put(URI.createURI(sammURI.lastSegment()), sammURI);
		sammResource = resSet.createResource(sammURI);
		
		try {
			sammResource.load(null);
		} catch (Exception e1) {
			e1.getMessage();
			return;
		}
		
		if(sammResource.getContents().size() < 1){
			System.err.println("ERROR: SAM Resource is empty");
			return;
		}
		
		decoratorUri = URI.createURI(sammURI.trimFileExtension().appendFileExtension("sourcecodedecorator").lastSegment()).resolve(sammURI);
		
		//letting the user choose the decorator if it cannot be found at the default location
		if(!resSet.getURIConverter().exists(decoratorUri, null)){
			ResourceDialog decoratorChooser = new ResourceDialog(shell, "Choose source code decorator", SWT.SINGLE);
			
			//making sure that the correct file type is selected
			do{
				decoratorChooser.open();
			}while(decoratorChooser.getReturnCode() == Window.OK && (decoratorChooser.getURIs().isEmpty()
					|| !decoratorChooser.getURIs().get(0).fileExtension().equalsIgnoreCase("sourcecodedecorator")));
			
			if(decoratorChooser.getReturnCode() == Window.OK && !decoratorChooser.getURIs().isEmpty()
					&& decoratorChooser.getURIs().get(0).fileExtension().equalsIgnoreCase("sourcecodedecorator")){
				// Get the resource of the decorator file; 
				decoratorUri = decoratorChooser.getURIs().get(0);
			}else{
				// Using only the samm_repository to build visualization
				defaultNaming = true;
			}
		}
		
		if(!defaultNaming){
			decoratorResource = resSet.createResource(decoratorUri);
			try {
				decoratorResource.load(null);
			} catch (Exception e1) {
				e1.getMessage();
				defaultNaming = true;
			}
			//checking if the decorator contains any unresolved proxies
			Map<EObject, Collection<Setting>> proxyReferences = ProxyCrossReferencer.find(decoratorResource);
			
			for(Entry<EObject, Collection<Setting>> proxy : proxyReferences.entrySet()){
				URI proxyUri = EcoreUtil.getURI(proxy.getKey()).trimFragment();
				if(!resSet.getURIConverter().exists(proxyUri, null)){
					defaultNaming = true;
					System.err.println("ERROR: Could not resolve " + proxyUri);
					break;
				}
			}

			if(!defaultNaming){

				//invoke new background job
				Job job = new Job("GAST based naming"){
					@Override
					protected IStatus run(IProgressMonitor monitor) {
			
						// Get the first model element and cast it to the right type
						Repository sammRepository = (Repository) sammResource.getContents().get(0);
						SourceCodeDecoratorRepository decoratorRepository = (SourceCodeDecoratorRepository) decoratorResource.getContents().get(0); 
						RepositoryVizDecoratorSwitch decoratorSwitch = new RepositoryVizDecoratorSwitch();
						HashMap<String, EObject> idToEObject = decoratorSwitch.doSwitch(decoratorRepository);
						
						// Apply switch on the samm repository
						RepositoryVizSammSwitch mySwitch = new RepositoryVizSammSwitch(idToEObject, decoratorRepository);
						RepositoryVizNode myTree = (RepositoryVizNode) mySwitch.doSwitch(sammRepository);
						
						// Setting up the editor input: holding the tree and the style of the visualization
						final RepositoryVizEditorInput myEditorInput = new RepositoryVizEditorInput(myTree, action.getActionDefinitionId(), sammRepository);
						
						// Call a new thread to display the tree in the editor 
						Display.getDefault().syncExec(new Runnable() {
							
							@Override
							public void run() {
								try {
									IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
									IWorkbenchPage page = window.getActivePage();;
									
									page.openEditor(myEditorInput, "org.somox.feature.repositoryVisualistation.editor");
								} catch (PartInitException e) {
									e.printStackTrace();
								}
							}
						});
						return Status.OK_STATUS;
					}
		
				};
				job.schedule();
			}					
		}
		if(defaultNaming){
				Job defaultViz = new Job("Default naming based on SAMM repository") {
				
				@Override
				protected IStatus run(IProgressMonitor monitor) {
						
					// Get the first model element and cast it to the right type
					Repository sammRepository = (Repository) sammResource.getContents().get(0);
					
					// Apply switch on the samm repository
					RepositoryVizSammSwitch mySwitch = new RepositoryVizSammSwitch(null, null);
					RepositoryVizNode myTree = (RepositoryVizNode) mySwitch.doSwitch(sammRepository);
					
					// Setting up the editor input: holding the tree and the style of the visualization
					final RepositoryVizEditorInput myEditorInput = new RepositoryVizEditorInput(myTree, action.getActionDefinitionId(), sammRepository);
					
					// Call a new thread to display the tree in the editor 
					Display.getDefault().syncExec(new Runnable() {
						
						@Override
						public void run() {
							try {
								IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
								IWorkbenchPage page = window.getActivePage();;
								
								page.openEditor(myEditorInput, "org.somox.feature.repositoryVisualistation.editor");
							} catch (PartInitException e) {
								e.printStackTrace();
							}
						}
					});
					return Status.OK_STATUS;
				}
			};
			defaultViz.schedule();	
		}
	}
	
	
	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {

		if(selection instanceof IStructuredSelection) {
			Object mySelection = ((StructuredSelection) selection).getFirstElement();
			if(mySelection instanceof eu.qimpress.ide.backbone.core.model.IQModel){
				selectionURI = URI.createPlatformResourceURI((((eu.qimpress.ide.backbone.core.model.IQModel) mySelection).getCorrespondingResource().getFullPath().toString()), true);
			}
			if(mySelection instanceof IFile){
				selectionURI = URI.createPlatformResourceURI(((IFile) mySelection).getFullPath().toString(), true);
			}
		}
	}
}
