package eu.qimpress.ide.visualizations.resultviewer.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.part.ViewPart;

import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.resultmodel.AlternativeEvaluation;
import eu.qimpress.resultmodel.AnalysisResult;
import eu.qimpress.resultmodel.CpuResourceUtilization;
import eu.qimpress.resultmodel.HddResourceUtilization;
import eu.qimpress.resultmodel.MaintainabilityPredictionResult;
import eu.qimpress.resultmodel.PerformancePredictionResult;
import eu.qimpress.resultmodel.Reliability;
import eu.qimpress.resultmodel.ReliabilityPredictionResult;
import eu.qimpress.resultmodel.ResponseTime;
import eu.qimpress.resultmodel.Throughput;

public class ResultViewerView extends ViewPart {

	private IQRepository repos;
	private ResultViewerComposite rvc;

	@Override
	public void createPartControl(Composite parent) {
		rvc = new ResultViewerComposite(parent, SWT.NONE);
	}

	@Override
	public void setFocus() {
		// TODO Auto-generated method stub

	}

	public void setRepository(IQRepository repos) {
		String DEFAULT_FMT = "%.3f";
		String RELIABILITY_FMT = "%g";
		this.repos = repos;
		rvc.repos = repos;
		rvc.resultTree.removeAll();
		rvc.resultTree.getColumn(0).setText("Result");
		rvc.resultTree.getColumn(1).setText("10% Quantile");
		rvc.resultTree.getColumn(2).setText("90% Quantile");
		rvc.resultTree.getColumn(3).setText("Mean");
		rvc.resultTree.getColumn(4).setText("Median");
		rvc.resultTree.addListener(SWT.MouseDown, new Listener() {
			public void handleEvent(Event event) {
				Point point = new Point(event.x, event.y);
				TreeItem item = rvc.resultTree.getItem(point);
				if (item != null) {
					while (item.getParentItem() != null) {
						item = item.getParentItem();
					}
					rvc.displayAlternativeData(item);
				}
			}
		});
		Vector<String> names = new Vector<String>();
		try {
			// Add a listener, so we can toggle the AHP button
			// depending on the tree checkboxes
			rvc.resultTree.addListener(SWT.Selection, new Listener() {
				@Override
				public void handleEvent(Event event) {
					// We got a change in the selection, check what we need
					// todo with the AHP button
					System.out.println("Got event: " + event);
					String string = event.detail == SWT.CHECK ? "Checked"
							: "Selected";
					System.out.println(event.item + " " + string);

					rvc.updateAHPButtonStatus();

				}
			}

			);

			List<AlternativeEvaluation> aevals = repos
					.getAllAlternativeEvaluations();

			for (AlternativeEvaluation ae : aevals) {
				TreeItem item = new TreeItem(rvc.resultTree, SWT.NONE);
				item.setText(ae.getName() + " " + ae.getId());
				for (AnalysisResult ar : ae.getAnalysisResults()) {
					if (ar instanceof PerformancePredictionResult) {

						PerformancePredictionResult res = (PerformancePredictionResult) ar;
						TreeItem subItem = new TreeItem(item, SWT.NONE);
						subItem.setText("Performance");
						subItem.setGrayed(true);

						if (res.getResourceUtilizations().size() > 0) {
							TreeItem subItem1 = new TreeItem(subItem, SWT.NONE);
							subItem1
									.setText(new String[] { "CPU Resource Utilizations" });
							subItem1.setGrayed(true);
							for (CpuResourceUtilization res1 : res
									.getResourceUtilizations()) {
								TreeItem subItem11 = new TreeItem(subItem1,
										SWT.NONE);
								subItem11.setText(new String[] {
										String.format("Usage resource %d", res1
												.getExecutionResource()
												.getCoreId()),
										String.format(DEFAULT_FMT, res1
												.getResultDistribution()
												.get_10PercentQuantile()),
										String.format(DEFAULT_FMT, res1
												.getResultDistribution()
												.get_90PercentQuantile()),
										String.format(DEFAULT_FMT, res1
												.getResultDistribution()
												.getArithmeticMean()),
										String.format(DEFAULT_FMT, res1
												.getResultDistribution()
												.getMedian()) });
								subItem11.setGrayed(true);
							}
						}

						if (res.getResponseTimes().size() > 0) {
							TreeItem subItem2 = new TreeItem(subItem, SWT.NONE);
							subItem2.setText(new String[] { "Response Times" });
							subItem2.setGrayed(true);
							for (ResponseTime res1 : res.getResponseTimes()) {
								TreeItem subItem21 = new TreeItem(subItem2,
										SWT.NONE);
								subItem21.setText(new String[] {
										"System Call "
												+ res1.getUsageScenario()
														.getName(),
										String.format(DEFAULT_FMT, res1
												.getResultDistribution()
												.get_10PercentQuantile()),
										String.format(DEFAULT_FMT, res1
												.getResultDistribution()
												.get_90PercentQuantile()),
										String.format(DEFAULT_FMT, res1
												.getResultDistribution()
												.getArithmeticMean()),
										String.format(DEFAULT_FMT, res1
												.getResultDistribution()
												.getMedian()) });
								subItem21.setGrayed(true);

							}
						}

						if (res.getHddResourceUtilizations().size() > 0) {
							TreeItem subItem3 = new TreeItem(subItem, SWT.NONE);
							subItem3
									.setText(new String[] { "HDD Utilizations" });
							subItem3.setGrayed(true);
							for (HddResourceUtilization res1 : res
									.getHddResourceUtilizations()) {
								TreeItem subItem31 = new TreeItem(subItem3,
										SWT.NONE);
								subItem31.setText(new String[] {
										"Storage Resource "
												+ res1.getStorageResource()
														.getName(),
										String.format(DEFAULT_FMT, res1
												.getResultDistribution()
												.get_10PercentQuantile()),
										String.format(DEFAULT_FMT, res1
												.getResultDistribution()
												.get_90PercentQuantile()),
										String.format(DEFAULT_FMT, res1
												.getResultDistribution()
												.getArithmeticMean()),
										String.format(DEFAULT_FMT, res1
												.getResultDistribution()
												.getMedian()) });
								subItem31.setGrayed(true);

							}
						}

						if (res.getThroughputs().size() > 0) {
							TreeItem subItem4 = new TreeItem(subItem, SWT.NONE);
							subItem4.setText(new String[] { "Throughputs" });
							subItem4.setGrayed(true);
							for (Throughput res1 : res.getThroughputs()) {
								TreeItem subItem41 = new TreeItem(subItem4,
										SWT.NONE);
								subItem41.setText(new String[] {
										"System Call "
												+ res1.getUsageScenario()
														.getName(),
										String.format(DEFAULT_FMT, res1
												.getResultDistribution()
												.get_10PercentQuantile()),
										String.format(DEFAULT_FMT, res1
												.getResultDistribution()
												.get_90PercentQuantile()),
										String.format(DEFAULT_FMT, res1
												.getResultDistribution()
												.getArithmeticMean()),
										String.format(DEFAULT_FMT, res1
												.getResultDistribution()
												.getMedian()) });
								subItem41.setGrayed(true);

							}
						}
					} else if (ar instanceof ReliabilityPredictionResult) {

						ReliabilityPredictionResult res = (ReliabilityPredictionResult) ar;

						for (Reliability res1 : res.getReliabilities()) {
							TreeItem subItem = new TreeItem(item, SWT.NONE);
							subItem.setText(new String[] {
									"Reliability",
									String.format(RELIABILITY_FMT, res1
											.getResultDistribution()
											.get_10PercentQuantile()),
									String.format(RELIABILITY_FMT, res1
											.getResultDistribution()
											.get_90PercentQuantile()),
									String.format(RELIABILITY_FMT, res1
											.getResultDistribution()
											.getArithmeticMean()),
									String.format(RELIABILITY_FMT, res1
											.getResultDistribution()
											.getMedian()) });
							subItem.setGrayed(true);
						}
					} else if (ar instanceof MaintainabilityPredictionResult) {
						MaintainabilityPredictionResult res = (MaintainabilityPredictionResult) ar;
						TreeItem subItem = new TreeItem(item, SWT.NONE);
						subItem.setText("Maintainability");
						subItem.setGrayed(true);
						TreeItem subItem1 = new TreeItem(subItem, SWT.NONE);
						subItem1.setText(new String[] {
								"Costs",
								String.format(DEFAULT_FMT, res
										.getAggregatedCosts()) });
						subItem1.setGrayed(true);
						TreeItem subItem2 = new TreeItem(subItem, SWT.NONE);
						subItem2.setText(new String[] {
								"Time Effort",
								String.format(DEFAULT_FMT, res
										.getAggregatedTimeEffort()) });
						subItem2.setGrayed(true);

					}
				}

			}
		} catch (RepositoryException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
