package eu.qimpress.ide.visualizations.resultviewer.ui;

import java.util.ArrayList;

import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.tradeoff.ahp.AHPWizard;
import eu.qimpress.resultmodel.AlternativeEvaluation;

public class ResultViewerComposite extends Composite {

	private Label resultListLabel = null;
	public Tree resultTree = null;
	private Composite composite1 = null;
	private Button btnRunAhp = null;
	private Button btnCheckAll = null;
	private Button btnCheckNone = null;
	private Button btnInvertSelection = null;
	public IQRepository repos;
	private Text txtAlternativeEvaluationDescription = null;

	public ResultViewerComposite(Composite parent, int style) {
		super(parent, style);
		initialize();
	}

	private void initialize() {
		GridData gridData = new GridData();
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessVerticalSpace = true;
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		resultListLabel = new Label(this, SWT.NONE);
		resultListLabel.setText("Results");
		Label filler1 = new Label(this, SWT.NONE);
		resultTree = new Tree(this, SWT.CHECK);
		resultTree.setHeaderVisible(true);
		resultTree.setLayoutData(gridData);
		resultTree.setLinesVisible(true);
		TreeColumn treeColumn = new TreeColumn(resultTree, SWT.NONE);
		treeColumn.setWidth(300);
		TreeColumn treeColumn1 = new TreeColumn(resultTree, SWT.NONE);
		treeColumn1.setWidth(60);
		TreeColumn treeColumn2 = new TreeColumn(resultTree, SWT.NONE);
		treeColumn2.setWidth(60);
		TreeColumn treeColumn3 = new TreeColumn(resultTree, SWT.NONE);
		treeColumn3.setWidth(60);
		TreeColumn treeColumn4 = new TreeColumn(resultTree, SWT.NONE);
		treeColumn4.setWidth(60);
		this.setLayout(gridLayout);
		createComposite1();
		setSize(new Point(622, 236));

	}

	/**
	 * This method initializes composite1
	 * 
	 */
	private void createComposite1() {
		GridData gridData6 = new GridData();
		gridData6.grabExcessVerticalSpace = true;
		gridData6.verticalAlignment = GridData.FILL;
		gridData6.horizontalAlignment = GridData.BEGINNING;
		gridData6.widthHint = 220;
		GridData gridData5 = new GridData();
		gridData5.grabExcessHorizontalSpace = true;
		gridData5.verticalAlignment = GridData.CENTER;
		gridData5.horizontalAlignment = GridData.BEGINNING;
		gridData5.widthHint = 100;
		GridLayout gridLayout1 = new GridLayout();
		gridLayout1.verticalSpacing = 5;
		GridData gridData4 = new GridData();
		gridData4.horizontalAlignment = GridData.BEGINNING;
		gridData4.grabExcessHorizontalSpace = true;
		gridData4.verticalAlignment = GridData.CENTER;
		gridData4.widthHint = 100;
		GridData gridData3 = new GridData();
		gridData3.horizontalAlignment = GridData.BEGINNING;
		gridData3.grabExcessHorizontalSpace = true;
		gridData3.verticalAlignment = GridData.CENTER;
		gridData3.widthHint = 100;
		GridData gridData2 = new GridData();
		gridData2.horizontalAlignment = GridData.BEGINNING;
		gridData2.grabExcessHorizontalSpace = true;
		gridData2.horizontalIndent = 0;
		gridData2.verticalAlignment = GridData.CENTER;
		gridData2.widthHint = 100;
		GridData gridData1 = new GridData();
		gridData1.grabExcessHorizontalSpace = false;
		gridData1.horizontalAlignment = GridData.FILL;
		gridData1.verticalAlignment = GridData.FILL;
		gridData1.grabExcessVerticalSpace = true;
		composite1 = new Composite(this, SWT.NONE);
		composite1.setLayoutData(gridData1);
		composite1.setLayout(gridLayout1);
		btnCheckAll = new Button(composite1, SWT.NONE);
		btnCheckAll.setText("Check All");
		btnCheckAll.setLayoutData(gridData4);
		btnCheckAll
				.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
					public void widgetSelected(
							org.eclipse.swt.events.SelectionEvent e) {
						for (int i = 0; i < resultTree.getItemCount(); i++) {
							resultTree.getItem(i).setChecked(true);
						}
						updateAHPButtonStatus();
					}
				});
		btnCheckNone = new Button(composite1, SWT.NONE);
		btnCheckNone.setText("Check None");
		btnCheckNone.setLayoutData(gridData3);
		btnInvertSelection = new Button(composite1, SWT.NONE);
		btnInvertSelection.setText("Invert Selection");
		btnInvertSelection.setLayoutData(gridData5);
		btnInvertSelection
				.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
					public void widgetSelected(
							org.eclipse.swt.events.SelectionEvent e) {
						for (int i = 0; i < resultTree.getItemCount(); i++) {
							resultTree.getItem(i).setChecked(
									!resultTree.getItem(i).getChecked());
						}
						updateAHPButtonStatus();
					}
				});
		btnCheckNone
				.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
					public void widgetSelected(
							org.eclipse.swt.events.SelectionEvent e) {
						for (int i = 0; i < resultTree.getItemCount(); i++) {
							resultTree.getItem(i).setChecked(false);
						}
						updateAHPButtonStatus();
					}
				});
		btnRunAhp = new Button(composite1, SWT.NONE);
		btnRunAhp.setText("Run AHP");
		btnRunAhp.setLayoutData(gridData2);
		btnRunAhp.setEnabled(false);
		txtAlternativeEvaluationDescription = new Text(composite1, SWT.MULTI
				| SWT.WRAP | SWT.V_SCROLL);
		txtAlternativeEvaluationDescription.setLayoutData(gridData6);
		// Add event handler for the event that an user clicks on the AHP button
		btnRunAhp
				.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
					public void widgetSelected(
							org.eclipse.swt.events.SelectionEvent e) {
						ArrayList<AlternativeEvaluation> selectedEvaluations = getSelectedAlternativeEvaluations();

						WizardDialog dialog = new WizardDialog(getShell(),
								new AHPWizard(selectedEvaluations));
						dialog.open();
					}
				});
	}

	public void displayAlternativeData(TreeItem item) {
		String str = item.getText();
		str = str.substring(str.lastIndexOf(' ') + 1);
		try {
			for (AlternativeEvaluation ae : repos
					.getAllAlternativeEvaluations()) {

				if (ae.getId().equals(str) && (ae.getUsageModel() != null)) {
					txtAlternativeEvaluationDescription.setText(String.format(
							"Alternative ID: %s\nUsageModel: %s", ae
									.getAlternativeId(), ae.getUsageModel()
									.getName()));

				}
			}
		} catch (RepositoryException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}
	
	/**
	 * Method to check the state of the AHP button, which is dependent on the
	 * number of alternative evaluations selected.
	 */
	protected void updateAHPButtonStatus() {
		ArrayList<AlternativeEvaluation> selectedEvaluations = getSelectedAlternativeEvaluations();
		if (selectedEvaluations.size() >= 2) {
			// Make AHP button active
			btnRunAhp.setEnabled(true);
		} else {
			// Make AHP button inactive, as not enough Alternative Evaluations have been
			// selected to use in the AHP analysis.
			btnRunAhp.setEnabled(false);
		}		
	}
	
	private ArrayList<AlternativeEvaluation> getSelectedAlternativeEvaluations() {
		ArrayList<AlternativeEvaluation> selectedEvaluations = new ArrayList<AlternativeEvaluation>();
		for (int i = 0; i < resultTree.getItemCount(); i++) {
			if (resultTree.getItem(i).getChecked()) {
				String str = resultTree.getItem(i).getText();
				try {
					for (AlternativeEvaluation ae : repos
							.getAllAlternativeEvaluations()) {
						if (ae.getId().equals(
								str.substring(str
										.lastIndexOf(' ') + 1))) {
							selectedEvaluations.add(ae);
						}
					}
				} catch (RepositoryException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				}

			}

		}
		return selectedEvaluations;
	}

} // @jve:decl-index=0:visual-constraint="-16,12"
