/**
 * 
 */
package eu.qimpress.transformations.sofa2.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

/**
 * 
 * @author Viliam Simko
 */
public class TransformConfigTab extends AbstractLaunchConfigurationTab {

	protected Text sammInstanceFilenameText;
	protected Text sofaRepositoryUrlText;
	protected List transformType;

	final static public String CFG_TRANSFORM_TYPE_SOFATOSAMM = "SOFA2 to SAMM";
	final static public String CFG_TRANSFORM_TYPE_SAMMTOSOFA = "SAMM to SOFA2";

	final static public String CFG_SAMM_FILE = "eu.qimpress.transformations.sofa2.qvt.sammfile";
	final static public String CFG_SOFA_REPO = "eu.qimpress.transformations.sofa2.qvt.sofarepo";
	final static public String CFG_TRANSFORM_TYPE = "eu.qimpress.transformations.sofa2.qvt.transtype";

	final static private String SAMM_FILE_LABEL = "SAMM instance file:";
	final static private String SAMM_FILE_TOOLTIP = "Select a XMI file containing the SAMM instance";

	final static private String SOFA2_REPO_LABEL = "URL of the SOFA2 repository:";
	final static private String SOFA2_REPO_TOOLTIP = "URL of a running SOFA2 repository e.g. http://localhost:8173/SofaServlet";

	final static private String TRANSTYPE_LABEL = "Transformation type:";
	final static private String TRANSTYPE_TOOLTIP = "Which type of the transformation should be performed";

	final static private String DEFAULT_SOFA_ADDRESS = "http://localhost:8173/SofaServlet";

	@Override
	public void createControl(Composite parent) {

		// =====================================================================
		// Root container configuration
		// =====================================================================

		Composite rootContainer = new Composite(parent, SWT.NULL);
		rootContainer.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		rootContainer.setLayout(new GridLayout(3, false));
		setControl(rootContainer);

		Button selectionButton = null;
		GridData data = null;

		// =====================================================================
		// XMI file representing the SAMM instance
		// =====================================================================

		Label behavProtFileLabel = new Label(rootContainer, SWT.NONE);
		behavProtFileLabel.setText(SAMM_FILE_LABEL);
		behavProtFileLabel.setToolTipText(SAMM_FILE_TOOLTIP);

		sammInstanceFilenameText = new Text(rootContainer, SWT.SINGLE
				| SWT.BORDER);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.widthHint = 200;
		sammInstanceFilenameText.setLayoutData(data);
		sammInstanceFilenameText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				setDirty(true);
				updateLaunchConfigurationDialog();
			}
		});

		// generate the BROWSE button
		selectionButton = new Button(rootContainer, SWT.PUSH);
		selectionButton.setText("Browse");
		selectionButton.addSelectionListener(new SelectionAdapter() {

			public void widgetSelected(SelectionEvent e) {

				// Open a file dialog to select the SAMM instance
				FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(
						getShell(),
						false, // single file
						ResourcesPlugin.getWorkspace().getRoot(),
						IResource.FILE);

				dialog.setInitialPattern("*.*");
				dialog.open();

				if (dialog.getReturnCode() == Window.OK) {
					sammInstanceFilenameText.setText(((IFile) dialog
							.getResult()[0]).getFullPath().toPortableString());
					setDirty(true);
					updateLaunchConfigurationDialog();
				}
			}
		});

		// =====================================================================
		// Select URL of the SOFA2 repository
		// =====================================================================

		Label label2 = new Label(rootContainer, SWT.NONE);
		label2.setText(SOFA2_REPO_LABEL);
		label2.setToolTipText(SOFA2_REPO_TOOLTIP);

		sofaRepositoryUrlText = new Text(rootContainer, SWT.SINGLE | SWT.BORDER);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.widthHint = 200;
		sofaRepositoryUrlText.setLayoutData(data);
		sofaRepositoryUrlText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				setDirty(true);
				updateLaunchConfigurationDialog();
			}
		});

		new Label(rootContainer, SWT.NONE);

		// =====================================================================
		// Select transformation type
		// =====================================================================

		Label label3 = new Label(rootContainer, SWT.NONE);
		label3.setText(TRANSTYPE_LABEL);
		label3.setToolTipText(TRANSTYPE_TOOLTIP);

		transformType = new List(rootContainer, SWT.SINGLE | SWT.BORDER);
		transformType.add(TransformConfigTab.CFG_TRANSFORM_TYPE_SAMMTOSOFA);
		// transformType.add(SammToSofaTabGroup.CFG_TRANSFORM_TYPE_SOFATOSAMM);
		transformType.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				setDirty(true);
				updateLaunchConfigurationDialog();
			}
		});

		// =====================================================================
		// Tmp dir
		// =====================================================================
	}

	@Override
	public String getName() {
		return "SAMM-SOFA2 Transformation";
	}

	@Override
	public void initializeFrom(ILaunchConfiguration conf) {

		try {
			sammInstanceFilenameText.setText(conf.getAttribute(
					TransformConfigTab.CFG_SAMM_FILE, ""));

			sofaRepositoryUrlText.setText(conf.getAttribute(
					TransformConfigTab.CFG_SOFA_REPO, ""));

			transformType.setSelection(new String[] { conf.getAttribute(
					TransformConfigTab.CFG_TRANSFORM_TYPE, "") });

		} catch (CoreException e) {
			e.printStackTrace();
		}
	}

	@Override
	public void performApply(ILaunchConfigurationWorkingCopy conf) {

		conf.setAttribute(TransformConfigTab.CFG_SAMM_FILE,
				this.sammInstanceFilenameText.getText());

		conf.setAttribute(TransformConfigTab.CFG_SOFA_REPO,
				this.sofaRepositoryUrlText.getText());

		String[] selectedItems = transformType.getSelection();
		if (selectedItems.length > 0) {
			// there should always be a single selected item
			conf.setAttribute(TransformConfigTab.CFG_TRANSFORM_TYPE,
					selectedItems[0]);
		}
	}

	@Override
	public void setDefaults(ILaunchConfigurationWorkingCopy conf) {
		conf.setAttribute(TransformConfigTab.CFG_SOFA_REPO,
				DEFAULT_SOFA_ADDRESS);

		conf.setAttribute(TransformConfigTab.CFG_TRANSFORM_TYPE,
				TransformConfigTab.CFG_TRANSFORM_TYPE_SAMMTOSOFA);
	}

	@Override
	public boolean isValid(ILaunchConfiguration launchConfig) {
		// File sammInstanceFile = new File(
		// launchConfig.getAttribute(SammToSofaTabGroup.CFG_SAMM_FILE, "") );
		return super.isValid(launchConfig);
	}

}
