package eu.qimpress.transformations.sofa2.ui;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;

import org.apache.log4j.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

import de.uka.ipd.sdq.workflow.Blackboard;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedLaunchConfigurationDelegate;
import de.uka.ipd.sdq.workflow.launchconfig.LoggerAppenderStruct;
import de.uka.ipd.sdq.workflow.ui.UIBasedWorkflow;
import eu.qimpress.transformations.sofa2.workflow.SammSofaJob;

/**
 * This class is registered as a launch configuration delegate in the plugin.xml
 * 
 * @author Viliam Simko
 */
public class TransformConfigDelegate
		extends
		AbstractWorkflowBasedLaunchConfigurationDelegate<TransformConfig, UIBasedWorkflow<Blackboard<String>>> {

	@Override
	protected IJob createWorkflowJob(TransformConfig config,
			ILaunch launch) throws CoreException {

		SammSofaJob job = new SammSofaJob(config);

		return job;
	}

	@Override
	protected TransformConfig deriveConfiguration(
			ILaunchConfiguration conf, String mode) throws CoreException {

		// We've got some strings in the launch configuration and we need to
		// turn them into some real objects
		TransformConfig realConf = new TransformConfig();

		// ITEM: where is the SOFA2 repository
		realConf.setSofaRepoAgent(conf.getAttribute(
				TransformConfigTab.CFG_SOFA_REPO, ""));
		
		// ITEM: where is the XMI file containing the SAMM model instance
		String fname = conf.getAttribute(TransformConfigTab.CFG_SAMM_FILE, "");
		IPath path = Path.fromPortableString(fname);
		IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
		URI uri = ifile.getLocationURI();

		realConf.setSammInstanceFile(new File(uri));

		// ITEM: type of the transformation
		realConf.setTransformType(conf.getAttribute(
				TransformConfigTab.CFG_TRANSFORM_TYPE, ""));

		// // ITEM: tmp dir for generated java files and compiled jars after
		// transformation
		// realConf.setTransformTmpDir(conf.getAttribute(
		// SammToSofaTabGroup.CFG_TRANSFORM_TMP_DIR, ""));

		return realConf;
	}

	@Override
	protected ArrayList<LoggerAppenderStruct> setupLogging(Level logLevel)
			throws CoreException {

		ArrayList<LoggerAppenderStruct> loggerList = new ArrayList<LoggerAppenderStruct>();

		// log initialization messages
		// loggerList.add(setupLogger("de.uka.ipd.sdq.workflow", logLevel,
		// SHORT_LOG_PATTERN));

		// log message from our job
		loggerList.add(setupLogger("eu.qimpress.transformations.sofa2",
				logLevel, SHORT_LOG_PATTERN));

		return loggerList;
	}
	
	

}
