/**
 * 
 */
package eu.qimpress.transformations.sofa2.ui;

import java.io.File;
import java.net.MalformedURLException;

import org.objectweb.dsrg.sofa.repository.ConfigurationHelper;
import org.objectweb.dsrg.sofa.repository.RepositoryAgent;
import org.objectweb.dsrg.sofa.repository.model.NodeConfiguration;

import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedRunConfiguration;

/**
 * Workflow configuration for SAMM to SOFA2 transformation.
 * 
 * @author Viliam Simko
 * @see SammSofaJob
 */
public class TransformConfig extends
		AbstractWorkflowBasedRunConfiguration {

	@Override
	public String getErrorMessage() {
		if (sofaRepoAgent == null) {
			return "No repository agent could have been instantiated. (not connected to the SOFA2 repository)";
		}

		return null;
	}

	@Override
	public void setDefaults() {
		// TODO Auto-generated method stub
	}

	/**
	 * The RepositoryAgent represents the connection to the SOFA2 repository.
	 */
	private RepositoryAgent sofaRepoAgent;

	/**
	 * Use an existing SOFA2 repository connection.
	 * 
	 * @param sofaRepoAgent
	 */
	public void setSofaRepoAgent(RepositoryAgent sofaRepoAgent) {
		this.sofaRepoAgent = sofaRepoAgent;
	}

	/**
	 * Connects to the SOFA2 repository at given URL.
	 * 
	 * @param sofaRepoUrl
	 * @throws MalformedURLException
	 */
	public void setSofaRepoAgent(String sofaRepoUrl) {
		NodeConfiguration configuration;
		try {
			configuration = ConfigurationHelper
					.createStandardConfiguration(sofaRepoUrl);
			setSofaRepoAgent(new RepositoryAgent(configuration));
		} catch (MalformedURLException e) {
			// disable the repository agent if the URL was invalid
			this.sofaRepoAgent = null;
		}
	}

	public RepositoryAgent getSofaRepoAgent() {
		return sofaRepoAgent;
	}

	/**
	 * Represents a file containing the instance of the SAMM model. File should
	 * be encoded in XMI format e.g. *.xmi, *.ecore ...
	 */
	private File sammInstanceFile;

	public void setSammInstanceFile(File sammInstanceFile) {
		this.sammInstanceFile = sammInstanceFile;
	}

	public void setSammInstanceFile(String sammInstanceFileName) {
		setSammInstanceFile(new File(sammInstanceFileName));
	}

	public File getSammInstanceFile() {
		return sammInstanceFile;
	}

	/**
	 * Type of the transformation.
	 */
	private String transformType;

	public void setTransformType(String transformType) {
		this.transformType = transformType;
	}

	public String getTransformType() {
		return transformType;
	}

	private File transformTmpDir;

	public void setTransformTmpDir(String dirName) {
		throw new UnsupportedOperationException();
		// this.transformTmpDir = new File(dirName);
	}

	/**
	 * Also ensures that the directory is writable and always exists.
	 * @return temporary directory
	 */
	public File getTransformTmpDir() {
		
		// instantiate if necessary
		if (transformTmpDir == null) {
			transformTmpDir = new File(new File(System
					.getProperty("java.io.tmpdir")), "sofa2-samm");
		}

		// create if necessary
		if (!transformTmpDir.exists()) {
			transformTmpDir.mkdir();
		}
		
		return transformTmpDir;
	}
}
