package eu.qimpress.transformations.sofa2.actions;

import java.io.File;
import java.util.Arrays;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.objectweb.dsrg.sofa.repository.model.RepositoryData;

public class Transform {

	final static private String QVTO_SAMM_TO_SOFA_SCRIPT = "eu.qimpress.transformations.sofa2/transforms/samm_to_sofa2.qvto";

	// final static private String QVTO_SOFA_TO_SAMM =
	// "eu.qimpress.transformations.sofa2/transforms/sofa2_to_samm.qvto";

	/**
	 * Transform given model file.
	 * 
	 * @param model
	 *            the model file
	 * @return output model
	 * @throws CoreException
	 */
	public RepositoryData doTransform(File model) throws CoreException {
		ResourceSet resourceSet = new ResourceSetImpl();

		// we assume that the URI is a local file
		URI modelUri = URI.createFileURI(model.getAbsolutePath());
		Resource resource = resourceSet.getResource(modelUri, true);

		EObject inputObject = resource.getContents().get(0);
		List<EObject> output = transform(Arrays.asList(inputObject));
		if (output.size() > 0) {
			return (RepositoryData) output.get(0);
		}
		return null;
	}

	/**
	 * Transform given list of Model {@link EObject}s to list of SOFA2ADL
	 * {@link EObject}s
	 * 
	 * @param objects
	 *            the objects to transform
	 * @return transformed objects
	 * @throws CoreException
	 */
	public List<EObject> transform(List<EObject> objects) throws CoreException {

		// get the path to the file containing the QVT-O transformation bundled
		// in the plugin
		URI transformationURI = URI.createPlatformPluginURI(QVTO_SAMM_TO_SOFA_SCRIPT,
				true);

		TransformationExecutor executor = new TransformationExecutor(
				transformationURI);

		ModelExtent input = new BasicModelExtent(objects);
		ModelExtent output = new BasicModelExtent();

		ExecutionDiagnostic result = executor.execute(
				new ExecutionContextImpl(), input, output);
		
		if (result.getSeverity() == Diagnostic.OK) {
			return output.getContents();
		} else {
			IStatus status = BasicDiagnostic.toIStatus(result);
			throw new CoreException(status);
		}
	}

}
