package eu.qimpress.transformations.sofa2;

import java.io.IOException;

import org.objectweb.dsrg.sofa.repository.RepositoryAgent;
import org.objectweb.dsrg.sofa.repository.model.Architecture;
import org.objectweb.dsrg.sofa.repository.model.Aspect;
import org.objectweb.dsrg.sofa.repository.model.InterfaceType;
import org.objectweb.dsrg.sofa.repository.model.RepositoryData;

public class SofaExperiment {

	RepositoryAgent agent;
	

	/**
	 * @param args
	 * @throws IOException 
	 */
	public static void main(String[] args) throws IOException {
		new SofaExperiment("http://localhost:8173/SofaServlet");
	}

	/**
	 * Cleanup the whole repository.
	 * 
	 * @param sofaServletURI
	 * @throws IOException 
	 */
	public SofaExperiment(String sofaServletURI) throws IOException {
		
		agent = RepositoryAgent.init();

		RepositoryData repodata = agent.getQuery().getRepositoryDataObject();

		//---------------
		for (Architecture item : repodata.getArchitecture()) {
			System.out.println(item.getName());
		}
		
		//---------------
		for (Aspect item : repodata.getAspect()) {
			System.out.println(item.getName());
		}
		
		//---------------
		for (InterfaceType item : repodata.getInterfaceType()) {
			System.out.println(item.getName());
		}

//		deleteAll(repodata.getArchitecture());
//		deleteAll(repodata.getAspect());
//		deleteAll(repodata.getAssemblyDescriptor());
//		deleteAll(repodata.getCodeBundle());
//		deleteAll(repodata.getDeploymentPlan());
//		deleteAll(repodata.getFrame());
//		deleteAll(repodata.getInterfaceType());
//		deleteAll(repodata.getMicroComponent());
//		deleteAll(repodata.getMicroInterfaceType());
	}

//	@SuppressWarnings("unchecked")
//	private void deleteAll(EList entList) {
//		if(entList.size() == 0)
//		{
//			System.out.println("Nothing to delete here.");
//			return;
//		}
//		
//		System.out.println("Deleting entities:" + entList.size());
//		
//		VersionedEntity[] list = new VersionedEntity[entList.size()];
//		
//		try {
//			agent.getFacade().deleteEntities(list, false);
//		} catch (IOException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//	}

}
