package eu.qimpress.transformations.samm2pcm.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

import de.uka.ipd.sdq.codegen.simucontroller.runconfig.SimuComConfigurationTab;
import de.uka.ipd.sdq.workflow.launchconfig.ConstantsContainer;

/**
 * The class defines a tab, which enhances the PCM SimuCom tab by adding additional SimuCom properties
 * for which separate tabs are used in the PCM. In Q-ImPrESS, all those properties are combined in
 * a single tab.
 * 
 * @author Michael Hauck
 */
public class SimuComQImPrESSConfigurationTab extends SimuComConfigurationTab {

	private static final String LABEL_SIMULATE_NETWORK = "Simulate linking resources";
	private Button simulateLinkingResourcesButton;

	/* (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {

		super.createControl(parent);
		
		// Create networking section:
		final Group networkingGroup = new Group(container, SWT.NONE);
		networkingGroup.setText("Networking");
		final GridData gd_networkingGroup = new GridData(SWT.FILL, SWT.CENTER,
				true, false);
		networkingGroup.setLayoutData(gd_networkingGroup);
		networkingGroup.setLayout(new GridLayout());
		simulateLinkingResourcesButton = new Button(networkingGroup, SWT.CHECK);
		final GridData gd_simulateLinkingResourcesButton = new GridData(
				SWT.FILL, SWT.CENTER, true, false);
		simulateLinkingResourcesButton
				.setLayoutData(gd_simulateLinkingResourcesButton);
		simulateLinkingResourcesButton.setText(LABEL_SIMULATE_NETWORK);
		simulateLinkingResourcesButton.addSelectionListener(new SelectionAdapter() {
			
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetSelected(SelectionEvent e) {
				SimuComQImPrESSConfigurationTab.this.updateLaunchConfigurationDialog();
			}
		});
		simulateLinkingResourcesButton.setSelection(false);
	}

	
	

	/* (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#initializeFrom(org.eclipse.debug.core.ILaunchConfiguration)
	 */
	public void initializeFrom(ILaunchConfiguration configuration) {
		super.initializeFrom(configuration);
		try {
			simulateLinkingResourcesButton
					.setSelection(configuration
							.getAttribute(
									ConstantsContainer.SIMULATE_LINKING_RESOURCES,
									true));
		} catch (CoreException e) {
			simulateLinkingResourcesButton.setSelection(false);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#performApply(org.eclipse.debug.core.ILaunchConfigurationWorkingCopy)
	 */
	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		super.performApply(configuration);
		configuration.setAttribute(
				ConstantsContainer.SIMULATE_LINKING_RESOURCES,
				this.simulateLinkingResourcesButton.getSelection());
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#setDefaults(org.eclipse.debug.core.ILaunchConfigurationWorkingCopy)
	 */
	public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
		super.setDefaults(configuration);
		configuration.setAttribute(
				ConstantsContainer.SIMULATE_LINKING_RESOURCES, false);
	}

	
	
}
