package eu.qimpress.transformations.samm2pcm.ui;

import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;

import de.uka.ipd.sdq.workflow.launchconfig.tabs.DebugEnabledCommonTab;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.ui.tabs.AlternativeSelectionListener;
import eu.qimpress.ide.backbone.core.ui.tabs.QImpressAlternativeEvaluationSelectionTab;
import eu.qimpress.ide.backbone.core.ui.tabs.QImpressAlternativeSelectionTab;
import eu.qimpress.ide.backbone.core.ui.tabs.QImpressUsageModelSelectionTab;


public class SAMM2PCMTabGroup extends AbstractLaunchConfigurationTabGroup {

	@Override
	public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
		final QImpressAlternativeSelectionTab qImpressAlternativeSelectionTab = new QImpressAlternativeSelectionTab();
		final QImpressUsageModelSelectionTab qImpressUsageModelSelectionTab = new QImpressUsageModelSelectionTab();
		qImpressAlternativeSelectionTab.addAlternativeSelectionListener(new AlternativeSelectionListener() {
			
			public void alternativeSelected(IQAlternative alternative) {
				qImpressUsageModelSelectionTab.setSelectedAlternative(alternative);
			}
		});
		ILaunchConfigurationTab[] tabs = new ILaunchConfigurationTab[] {
				qImpressAlternativeSelectionTab,
				qImpressUsageModelSelectionTab,
				new QImpressAlternativeEvaluationSelectionTab(),
				new SimuComQImPrESSConfigurationTab(),
				new DebugEnabledCommonTab()};
		setTabs(tabs);
	}
}
