/**
 * 
 */
package eu.qimpress.transformations.samm2pcm.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;

import de.uka.ipd.sdq.cip.configuration.CompletionConfiguration;
import de.uka.ipd.sdq.codegen.simucontroller.runconfig.SimuComWorkflowConfiguration;
import de.uka.ipd.sdq.simucomframework.SimuComConfig;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.launchconfig.ConstantsContainer;
import de.uka.ipd.sdq.workflow.launchconfig.configbuilder.AbstractUIBasedConfigurationBuilder;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ModelLocation;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvto.QVTOTransformationJobConfiguration;
import de.uka.ipd.sdq.workflow.pcm.jobs.LoadPCMModelsIntoBlackboardJob;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.IQElement.ElementType;
import eu.qimpress.ide.backbone.core.ui.tabs.QImpressAlternativeEvaluationSelectionTab;
import eu.qimpress.ide.backbone.core.ui.tabs.QImpressAlternativeSelectionTab;
import eu.qimpress.ide.backbone.core.ui.tabs.QImpressUsageModelSelectionTab;
import eu.qimpress.transformations.common.jobs.LoadSAMMAlternativeJob;
import eu.qimpress.transformations.common.jobs.LoadSAMMIntoBlackboardJob;

/**
 * @author Steffen Becker
 *
 */
public class SAMM2PCMConfigurationBuilder extends
		AbstractUIBasedConfigurationBuilder<SAMM2PCMConfiguration> {
	
	private static final int SAMM2PCM_PARAMETER_COUNT = 14;

	private static final Logger logger = Logger.getLogger(SAMM2PCMConfigurationBuilder.class);

	static final URI PCM_PALLADIO_RESOURCE_TYPE_URI = URI.createURI("pathmap://PCM_MODELS/Palladio.resourcetype");
	static final URI PCM_PALLADIO_PRIMITIVE_TYPE_REPOSITORY_URI = URI.createURI("pathmap://PCM_MODELS/PrimitiveTypes.repository");
	static final URI PCM_PALLADIO_MIDDLEWARE_FILE_URI = URI.createURI("pathmap://PCM_MODELS/Glassfish.repository");
	static final URI PCM_PALLADIO_FEATURE_CONFIG_FILE_URI = URI.createURI("pathmap://PCM_MODELS/ConnectorConfig.featureconfig");

	static final URI SAMM2PCM_QVTO_SCRIPT_FILE_URI = URI.createURI("platform:/plugin/eu.qimpress.transformations.samm2pcm/scripts/SAMM2PCM.qvto");

	/**
	 * @param attributes
	 */
	public SAMM2PCMConfigurationBuilder(Map<String, Object> attributes) {
		super(attributes);
	}

	/* (non-Javadoc)
	 * @see de.uka.ipd.sdq.workflow.launchconfig.configbuilder.AbstractUIBasedConfigurationBuilder#internalBuild(java.util.Map)
	 */
	@Override
	protected SAMM2PCMConfiguration internalBuild(Map<String, Object> attributes) {
		SAMM2PCMConfiguration result = new SAMM2PCMConfiguration();
		IQAlternative alternative = getAlternative(attributes);
		result.setAlternative(alternative);
		result.setUsageModelId(getUsageModelId(attributes));
		result.setAlternativeEvaluationId((String)attributes.get(QImpressAlternativeEvaluationSelectionTab.SELECTED_ALTERNATIVE_EVALUATION_ID));
		result.setAlternativeEvaluationProjectName((String)attributes.get(QImpressAlternativeEvaluationSelectionTab.SELECTED_PROJECT_NAME));
		
		try {
			result.setQvtoTransformationJobConfiguration(deriveQvtoConfiguration(attributes, alternative));
		} catch (JobFailedException e) {
			logger.error("Could not derive the QVT configuration.", e);
		}

		result.setSimuComWorkflowConfiguration(deriveSimuComWorkflowConfiguration(attributes));
		
		return result;
	}

	/**
	 * @param attributes
	 * @return
	 */
	private IQAlternative getAlternative(Map<String, Object> attributes) {
		IQAlternative alternative = null;
		IQElement element = QImpressApplicationModelManager.getManager().getQAppModel().getElementByID((String)attributes.get(QImpressAlternativeSelectionTab.SELECTED_ALTERNATIVE_GUID));
		if ((element != null) && (element.getElementType().equals(ElementType.Q_ALTERNATIVE))) {
			alternative = (IQAlternative) element;
		}
		if (alternative == null) {
			throw new RuntimeException("Launch configuration contains no valid alternative.");
		}
		return alternative;
	}
	
	/**
	 * @param attributes
	 * @return
	 */
	private String getUsageModelId(Map<String, Object> attributes) {
		String usageModelId = null;
		usageModelId = (String)attributes.get(QImpressUsageModelSelectionTab.SELECTED_USAGE_MODEL_ID);
		if ((usageModelId == null) || usageModelId.equals("")) {
			throw new RuntimeException("Launch configuration contains no valid usage model.");
		}
		return usageModelId;
	}
	
	public static SimuComWorkflowConfiguration deriveSimuComWorkflowConfiguration(Map<String, Object> attributes) {
		// Creating and setting SimuCom configuration
		SimuComWorkflowConfiguration simuComWorkflowConfiguration = new SimuComWorkflowConfiguration();
		simuComWorkflowConfiguration.setInteractive(true);
		simuComWorkflowConfiguration.setSimulateLinkingResources(getBooleanAttribute(attributes, ConstantsContainer.SIMULATE_LINKING_RESOURCES));

		// Not needed here, models are generated and written directly to PCM partition
//		File allocationFile = new File(alternativeFolderPlatform+"/pcm_output.allocation");
//		File usageModelFile = new File(alternativeFolderPlatform+"/pcm_output.usagemodel");
//
//		List<String> allocationFiles = new ArrayList<String>();
//		allocationFiles.add(allocationFile.getPath());
//		simuComWorkflowConfiguration.setAllocationFiles(allocationFiles);
//		simuComWorkflowConfiguration.setUsageModelFile(usageModelFile.getPath());
//			
		simuComWorkflowConfiguration.setMiddlewareFile(PCM_PALLADIO_MIDDLEWARE_FILE_URI.toString());
		simuComWorkflowConfiguration.setFeatureConfigFile(PCM_PALLADIO_FEATURE_CONFIG_FILE_URI.toString());
		simuComWorkflowConfiguration.setPluginID("de.uka.ipd.sdq.codegen.simucominstance");
		attributes.put("completion.qvt.verbose.logging", false);
		attributes.put("completion.config", new ArrayList<String>());
		simuComWorkflowConfiguration.setCompletionConfiguration(new CompletionConfiguration(attributes));
		simuComWorkflowConfiguration.setOverwriteWithoutAsking(true);
		
		Map<String,Object> configMap = new HashMap<String,Object>(attributes);
		configMap.put(SimuComConfig.SIMULATE_FAILURES,false);
		configMap.put(SimuComConfig.USE_FIXED_SEED, false);
		configMap.put(SimuComConfig.SIMULATE_LINKING_RESOURCES, getBooleanAttribute(attributes, ConstantsContainer.SIMULATE_LINKING_RESOURCES));
		SimuComConfig simuComConfig = new SimuComConfig(configMap, false);

		
		simuComWorkflowConfiguration.setSimuComConfiguration(simuComConfig);
		return simuComWorkflowConfiguration;
	}
	
	private QVTOTransformationJobConfiguration deriveQvtoConfiguration(Map<String, Object> attributes, IQAlternative alternative) throws JobFailedException {
		// Creating and setting transformation configuration
		QVTOTransformationJobConfiguration qvtoTransformationJobConfiguration = new QVTOTransformationJobConfiguration();
		
		String usageModelId = getUsageModelId(attributes);
		setQVTOOptions(qvtoTransformationJobConfiguration, usageModelId);
		qvtoTransformationJobConfiguration.setInoutModels(new ModelLocation[SAMM2PCM_PARAMETER_COUNT]);

		getInputParameter(alternative, qvtoTransformationJobConfiguration.getInoutModels());
		getOutputParameter(alternative, qvtoTransformationJobConfiguration.getInoutModels());

		URI traceFilePath = LoadSAMMAlternativeJob.getURIForQIElement(alternative).
					appendSegment("SAMM2PCM").
					appendSegment("SAMM2PCM.qvtotrace");
		qvtoTransformationJobConfiguration.setTraceFileURI(traceFilePath);
		qvtoTransformationJobConfiguration.setScriptFileURI(SAMM2PCM_QVTO_SCRIPT_FILE_URI);
		
		return qvtoTransformationJobConfiguration;
	}
	
	private static final String[] pcmExtensions = new String[]{
		"repository",
		"system",
		"resourceenvironment",
		"allocation",
		"usagemodel"
	};
	
	private static final int FIRST_OUT_PARAM_POSITION = LoadSAMMAlternativeJob.SAMM_EXTENSIONS.length + 2;

	/**
	 * @param alternative 
	 * @param modelLocations 
	 * 
	 */
	private void getOutputParameter(IQAlternative alternative, ModelLocation[] modelLocations) {
		URI alternativeLocation = LoadSAMMAlternativeJob.getURIForQIElement(alternative);
		for (int i = 0; i < pcmExtensions.length; i++) {
			modelLocations[FIRST_OUT_PARAM_POSITION + i] =
				new ModelLocation(PCM_PARTITION, 
						alternativeLocation.
						appendSegment("SAMM2PCM").
						appendSegment("pcm_output."+pcmExtensions[i]));
		}
	}

	/**
	 * @param qvtoTransformationJobConfiguration
	 */
	private void setQVTOOptions(
			QVTOTransformationJobConfiguration qvtoTransformationJobConfiguration, String usageModelId) {
		Map<String, Object> modelsTransformationOpt = new HashMap<String, Object>();
		modelsTransformationOpt.put("defaultEntityName", "defaultName");
		modelsTransformationOpt.put("defaultHddProcessingRateValue", "1.0");
		modelsTransformationOpt.put("defaultCpuProcessingRateValue", "1.0");
		modelsTransformationOpt.put("defaultNetworkBandwidthValue", "1.0");
		modelsTransformationOpt.put("defaultNetworkLatencyValue", "0.0");
		modelsTransformationOpt.put("systemModelName", "System");
		modelsTransformationOpt.put("allocationModelName", "Service");
		modelsTransformationOpt.put("usageModelId", usageModelId);
		qvtoTransformationJobConfiguration.setOptions(modelsTransformationOpt);
	}
	
	private static final String SAMM_PARTITION = LoadSAMMIntoBlackboardJob.SAMM_MODELS_PARTITION_ID;
	private static final String PCM_PARTITION = LoadPCMModelsIntoBlackboardJob.PCM_MODELS_PARTITION_ID;
	
	private void getInputParameter(IQAlternative selectedAlternative, ModelLocation[] modelLocations) throws JobFailedException {
		IQModel[] elements = selectedAlternative.getModels();
		IQModel[] inputElements = new IQModel[LoadSAMMAlternativeJob.SAMM_EXTENSIONS.length];
		int j = 0;
		for (IQModel element: elements) {
			if (LoadSAMMAlternativeJob.isNecessaryModelForTransformation(element)) {
				inputElements[j] = element; 
				j++;
			}
		}
		int i=0;
		for (String extension : LoadSAMMAlternativeJob.SAMM_EXTENSIONS) {
			modelLocations[i++] = 
				new ModelLocation(SAMM_PARTITION,LoadSAMMAlternativeJob.getResourceURI(inputElements, extension));
		}
	
		
		//Do not consider the result model as part of the SAMM, this is messy, talk to Luigi for alternatives
		//i--;
		
		modelLocations[i++] = 
			new ModelLocation(PCM_PARTITION, PCM_PALLADIO_PRIMITIVE_TYPE_REPOSITORY_URI);
		modelLocations[i++] = 
			new ModelLocation(PCM_PARTITION, PCM_PALLADIO_RESOURCE_TYPE_URI);
	}
	
	private static Boolean hasAttribute(Map<String,Object> attributes, String attribute) {
		if (!attributes.containsKey(attribute)) {
			return false;	
		}
		return true;
	}
	
	private static Boolean getBooleanAttribute(Map<String,Object> attributes, String attribute) {
		if (!hasAttribute(attributes, attribute)) {
			return false;
		}
		
		Object value = attributes.get(attribute);
		if (!(value instanceof Boolean)) {
			throw new IllegalArgumentException("Tried to read non-boolean value as boolean value");
		}
		return (Boolean)value;
	}
	
	
}
