/**
 * 
 */
package eu.qimpress.transformations.samm2pcm.multiple;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.ui.widgets.QAlternativesTreeViewerFactory;
import eu.qimpress.ide.backbone.core.ui.widgets.QAlternativesTreeViewerFactory.SelectAlternativesEnum;

/**
 * @author Steffen Becker
 *
 */
public class QImpressMultipleAlternativeSelectionTab 
extends	AbstractLaunchConfigurationTab {
	
	public static final String SELECTED_ALTERNATIVES_GUID = "eu.qimpress.reverseengineering.alternativesselection";
	private CheckboxTreeViewer myAlternativesViewer;
	private Label selectionText;

	/**
	 * @wbp.parser.entryPoint
	 */
	@Override
	public void createControl(Composite parent) {
		Composite myTabControl = new Composite(parent,SWT.NONE);
		GridLayout gridLayout = new GridLayout();
		gridLayout.marginWidth = 5;
		gridLayout.marginHeight = 5;
		gridLayout.numColumns = 2;
		myTabControl.setLayout(gridLayout);
		setControl(myTabControl);
		
		Group grpSelectQimpressAlternative = new Group(myTabControl, SWT.FILL);
		grpSelectQimpressAlternative.setText("Select Q-ImPrESS Alternative");
		FillLayout fillLayout = new FillLayout(SWT.HORIZONTAL);
		fillLayout.marginWidth = 5;
		fillLayout.marginHeight = 5;
		grpSelectQimpressAlternative.setLayout(fillLayout);
		grpSelectQimpressAlternative.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true,2,1));
			
		myAlternativesViewer = (CheckboxTreeViewer) QAlternativesTreeViewerFactory.createTreeViewer(grpSelectQimpressAlternative, SelectAlternativesEnum.SELECT_MULTIPLE).getTreeViewer();
		myAlternativesViewer.addCheckStateListener(new ICheckStateListener() {
			
			public void checkStateChanged(CheckStateChangedEvent event) {
				if (event.getElement() instanceof IQAlternative) {
					IQAlternative alt =  (IQAlternative) event.getElement();
					selectionText.setText(alt.getInfo().getDescription());
				} else {
					selectionText.setText("<none>");
				}
				setDirty(true);
				updateLaunchConfigurationDialog();
			}
		});
		
		Label selection = new Label(myTabControl,SWT.NONE);
		selection.setText("Selected Top-Level Alternative: ");
		selection.setLayoutData(new GridData(SWT.FILL,SWT.FILL,false,false,1,1));
		
		selectionText = new Label(myTabControl,SWT.NONE);
		selectionText.setText("<none>");
		selectionText.setLayoutData(new GridData(SWT.FILL,SWT.FILL,false,false,1,1));
		
	}

	@Override
	public String getName() {
		return "QImPrESS Alternative";
	}

	@SuppressWarnings("unchecked")
	@Override
	public void initializeFrom(ILaunchConfiguration configuration) {
		List<String> guids = null; 
		try {
			guids = configuration.getAttribute(SELECTED_ALTERNATIVES_GUID, new ArrayList<String>());
		} catch (CoreException e) { }
		if ((guids!= null) && (guids.size() > 0)) {
			myAlternativesViewer.expandAll();
			IQApplicationModel model = (IQApplicationModel) myAlternativesViewer.getInput();
			for (String guid : guids) {
				IQElement alternative = model.getElementByID(guid);
				if (alternative != null) {
					
					myAlternativesViewer.setChecked(alternative, true);
				}
			}
		}
	}

	@Override
	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		Object[] elements = myAlternativesViewer.getCheckedElements();
		List<String> selectedIds = new ArrayList<String>();
		if (elements.length > 0) {
			for (Object element : elements) {
				if (element instanceof IQAlternative) {
					IQAlternative selectedAlternative = (IQAlternative) element;
					selectedIds.add(selectedAlternative.getInfo().getId());
				}
			}
		}
		configuration.setAttribute(SELECTED_ALTERNATIVES_GUID, selectedIds);
	}

	
	@Override
	public boolean isValid(ILaunchConfiguration launchConfig) {
		if (!super.isValid(launchConfig)) return false;
		
		return getErrorMessage() == null;
	}

	
	@Override
	public String getErrorMessage() {
		Object[] elements = myAlternativesViewer.getCheckedElements();
		if (elements.length < 1) return "Select at least one alternative";
		for (Object element : elements) {
			if (!(element instanceof IQAlternative)) return "Selection is not an alternative";	
		}
		
		//IQAlternative selectedAlternative = (IQAlternative) elements[0];
		// if (selectedAlternative. ... )
		
		return null;
	}

	@Override
	public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
		configuration.setAttribute(SELECTED_ALTERNATIVES_GUID, new ArrayList<String>());
	}
}
