package eu.qimpress.transformations.samm2pcm.multiple;

import java.util.ArrayList;

import org.apache.log4j.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

import de.uka.ipd.sdq.codegen.simucontroller.debug.IDebugListener;
import de.uka.ipd.sdq.codegen.simucontroller.debug.SimulationDebugListener;
import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.SimuComJob;
import de.uka.ipd.sdq.workflow.BlackboardBasedWorkflow;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.LowMemoryFootprintCompositeJob;
import de.uka.ipd.sdq.workflow.OrderPreservingBlackboardCompositeJob;
import de.uka.ipd.sdq.workflow.launchconfig.AbstractConfigBuilderBasedLaunchConfigurationDelegate;
import de.uka.ipd.sdq.workflow.launchconfig.LoggerAppenderStruct;
import de.uka.ipd.sdq.workflow.launchconfig.configbuilder.AbstractUIBasedConfigurationBuilder;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.SavePartitionToDiskJob;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvto.QVTOTransformationJob;
import de.uka.ipd.sdq.workflow.pcm.jobs.LoadPCMModelsIntoBlackboardJob;
import de.uka.ipd.sdq.workflow.pcm.jobs.PreparePCMBlackboardPartionJob;
import de.uka.ipd.sdq.workflow.ui.UIBasedWorkflow;
import eu.qimpress.transformations.common.jobs.LoadSAMMIntoBlackboardJob;
import eu.qimpress.transformations.common.jobs.SAMMValidationJob;
import eu.qimpress.transformations.samm2pcm.jobs.LoadPCMFeatureModelJob;
import eu.qimpress.transformations.samm2pcm.ui.SAMM2PCMConfiguration;

public class MultipleSAMM2PCMConfigurationDelegate extends
AbstractConfigBuilderBasedLaunchConfigurationDelegate<MultipleSAMM2PCMConfiguration, BlackboardBasedWorkflow<MDSDBlackboard>> {

	private static final String LOG_PATTERN = "%-5p: %m\n";
	public static final String OAW_SAMM2PCM_CHECK_FILE = "samm2pcm";
		
	@Override
	protected IJob createWorkflowJob(MultipleSAMM2PCMConfiguration config,
			ILaunch launch) throws CoreException {

		//OrderPreservingBlackboardCompositeJob<MDSDBlackboard> myJob = new OrderPreservingBlackboardCompositeJob<MDSDBlackboard>();
		LowMemoryFootprintCompositeJob<MDSDBlackboard> myJob = new LowMemoryFootprintCompositeJob<MDSDBlackboard>();
		//OrderPreservingBlackboardCompositeJob<MDSDBlackboard> nestedJob = new OrderPreservingBlackboardCompositeJob<MDSDBlackboard>();
		myJob.setName("Multiple SAMM2PCM Main Task");
		for (SAMM2PCMConfiguration samm2pcmConfiguration : config.getSamm2pcmConfigurations()) {
			OrderPreservingBlackboardCompositeJob<MDSDBlackboard> nestedJob = new OrderPreservingBlackboardCompositeJob<MDSDBlackboard>();
			nestedJob.add(new PreparePCMBlackboardPartionJob());
			// Caution: SAMM2PCM does not use the common usage repository
			nestedJob.add(new LoadSAMMIntoBlackboardJob(samm2pcmConfiguration.getAlternative()));
			nestedJob.add(new SAMMValidationJob(samm2pcmConfiguration, SAMMValidationJob.OAW_CORE_SAMM_CHECK_FILE, OAW_SAMM2PCM_CHECK_FILE));
			
			QVTOTransformationJob qvtoTransformationJob = 
				new QVTOTransformationJob(samm2pcmConfiguration.getQvtoTransformationJobConfiguration());
			nestedJob.add(qvtoTransformationJob);

			nestedJob.add(new LoadPCMFeatureModelJob(samm2pcmConfiguration));
			nestedJob.add(new SavePartitionToDiskJob(LoadPCMModelsIntoBlackboardJob.PCM_MODELS_PARTITION_ID));

			IDebugListener debugListener = null;
			if (config.isDebug() || samm2pcmConfiguration.isDebug()) {
				debugListener = new SimulationDebugListener(launch);
			}
			SimuComJob simuComJob = new SimuComJob(samm2pcmConfiguration.getSimuComWorkflowConfiguration(), debugListener, false);
			nestedJob.add(simuComJob);
			StorePcmResultsToCsvJob storePcmResultsToCsvJob = new StorePcmResultsToCsvJob(samm2pcmConfiguration);
			nestedJob.add(storePcmResultsToCsvJob);
			myJob.add(nestedJob);
		}
		
		return myJob;
	}
	
	@Override
	protected UIBasedWorkflow<MDSDBlackboard> createWorkflow(
			MultipleSAMM2PCMConfiguration workflowConfiguration, 
			IProgressMonitor monitor,
			ILaunch launch) throws CoreException {
		return new UIBasedWorkflow<MDSDBlackboard>(
				createWorkflowJob(workflowConfiguration, launch), 
				monitor,
				createExcpetionHandler(workflowConfiguration.isInteractive()),
				new MDSDBlackboard());
	}
		
	@Override
	protected ArrayList<LoggerAppenderStruct> setupLogging(Level logLevel)
			throws CoreException {
		
		ArrayList<LoggerAppenderStruct> loggerList = super.setupLogging(logLevel);

		loggerList.add(setupLogger("eu.qimpress.transformations.samm2pcm", logLevel, LOG_PATTERN));
		loggerList.add(setupLogger("eu.qimpress.transformations.common", logLevel, LOG_PATTERN));

		return loggerList;
	}

	@SuppressWarnings("unchecked")
	@Override
	protected AbstractUIBasedConfigurationBuilder<MultipleSAMM2PCMConfiguration> getConfigurationBuilder(
			ILaunchConfiguration configuration) throws CoreException {
		return new MultipleSAMM2PCMConfigurationBuilder(configuration.getAttributes());
	}

}
