/**
 * 
 */
package eu.qimpress.transformations.samm2pcm.multiple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;

import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.launchconfig.configbuilder.AbstractUIBasedConfigurationBuilder;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ModelLocation;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvto.QVTOTransformationJobConfiguration;
import de.uka.ipd.sdq.workflow.pcm.jobs.LoadPCMModelsIntoBlackboardJob;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.model.RepositoryModels;
import eu.qimpress.ide.backbone.core.model.IQElement.ElementType;
import eu.qimpress.samm.usagemodel.UsageRepository;
import eu.qimpress.transformations.common.jobs.LoadSAMMAlternativeJob;
import eu.qimpress.transformations.common.jobs.LoadSAMMIntoBlackboardJob;
import eu.qimpress.transformations.samm2pcm.ui.SAMM2PCMConfiguration;
import eu.qimpress.transformations.samm2pcm.ui.SAMM2PCMConfigurationBuilder;

public class MultipleSAMM2PCMConfigurationBuilder extends
		AbstractUIBasedConfigurationBuilder<MultipleSAMM2PCMConfiguration> {
	
	private static final int SAMM2PCM_PARAMETER_COUNT = 14;

	private static final Logger logger = Logger.getLogger(MultipleSAMM2PCMConfigurationBuilder.class);

	static final URI PCM_PALLADIO_RESOURCE_TYPE_URI = URI.createURI("pathmap://PCM_MODELS/Palladio.resourcetype");
	static final URI PCM_PALLADIO_PRIMITIVE_TYPE_REPOSITORY_URI = URI.createURI("pathmap://PCM_MODELS/PrimitiveTypes.repository");
	static final URI PCM_PALLADIO_MIDDLEWARE_FILE_URI = URI.createURI("pathmap://PCM_MODELS/Glassfish.repository");
	static final URI PCM_PALLADIO_FEATURE_CONFIG_FILE_URI = URI.createURI("pathmap://PCM_MODELS/ConnectorConfig.featureconfig");

	static final URI SAMM2PCM_QVTO_SCRIPT_FILE_URI = URI.createURI("platform:/plugin/eu.qimpress.transformations.samm2pcm/scripts/SAMM2PCM.qvto");

	/**
	 * @param attributes
	 */
	public MultipleSAMM2PCMConfigurationBuilder(Map<String, Object> attributes) {
		super(attributes);
	}

	/* (non-Javadoc)
	 * @see de.uka.ipd.sdq.workflow.launchconfig.configbuilder.AbstractUIBasedConfigurationBuilder#internalBuild(java.util.Map)
	 */
	@Override
	protected MultipleSAMM2PCMConfiguration internalBuild(Map<String, Object> attributes) {
		MultipleSAMM2PCMConfiguration result = new MultipleSAMM2PCMConfiguration();
		List<SAMM2PCMConfiguration> samm2pcmConfigurations = new ArrayList<SAMM2PCMConfiguration>();
		List<IQAlternative> alternatives = getAlternatives(attributes);
		for (IQAlternative alternative : alternatives) {
			SAMM2PCMConfiguration samm2pcmConfiguration = new SAMM2PCMConfiguration();
			samm2pcmConfiguration.setAlternative(alternative);
			samm2pcmConfiguration.setUsageModelId(getLocalUsageModelId(alternative));
			samm2pcmConfiguration.setQvtoTransformationJobConfiguration(deriveQvtoConfiguration(attributes, alternative));
			samm2pcmConfiguration.setSimuComWorkflowConfiguration(SAMM2PCMConfigurationBuilder.deriveSimuComWorkflowConfiguration(attributes));
			samm2pcmConfigurations.add(samm2pcmConfiguration);
		}
		result.setSamm2pcmConfigurations(samm2pcmConfigurations);
		
		return result;
	}

	/**
	 * @param attributes
	 * @return
	 */
	@SuppressWarnings("unchecked")
	private List<IQAlternative> getAlternatives(Map<String, Object> attributes) {
		List<IQAlternative> alternatives = new ArrayList<IQAlternative>();
		List<String> alternativeIds = (List<String>)attributes.get(QImpressMultipleAlternativeSelectionTab.SELECTED_ALTERNATIVES_GUID);
		if ((alternativeIds != null) && (alternativeIds.size() > 0)) {
			for (String alternativeId : alternativeIds) {
				IQElement element = QImpressApplicationModelManager.getManager().getQAppModel().getElementByID(alternativeId);
				if ((element != null) && (element.getElementType().equals(ElementType.Q_ALTERNATIVE))) {
					alternatives.add((IQAlternative) element);
				}
				
			}
		}
		if (alternatives == null) {
			throw new RuntimeException("Launch configuration contains no valid alternative.");
		}
		return alternatives;
	}
	
	/*private SimuComWorkflowConfiguration deriveSimuComWorkflowConfiguration(Map<String, Object> attributes) {
		// Creating and setting SimuCom configuration
		SimuComWorkflowConfiguration simuComWorkflowConfiguration = new SimuComWorkflowConfiguration();
		simuComWorkflowConfiguration.setInteractive(true);
		simuComWorkflowConfiguration.setSimulateLinkingResources(false);
		simuComWorkflowConfiguration.setPluginID("de.uka.ipd.sdq.codegen.simucominstance");
		simuComWorkflowConfiguration.setOverwriteWithoutAsking(true);

		// Not needed here, models are generated and written directly to PCM partition
//		File allocationFile = new File(alternativeFolderPlatform+"/pcm_output.allocation");
//		File usageModelFile = new File(alternativeFolderPlatform+"/pcm_output.usagemodel");
//
//		List<String> allocationFiles = new ArrayList<String>();
//		allocationFiles.add(allocationFile.getPath());
//		simuComWorkflowConfiguration.setAllocationFiles(allocationFiles);
//		simuComWorkflowConfiguration.setUsageModelFile(usageModelFile.getPath());
//			
		simuComWorkflowConfiguration.setMiddlewareFile(PCM_PALLADIO_MIDDLEWARE_FILE_URI.toString());
		simuComWorkflowConfiguration.setFeatureConfigFile(PCM_PALLADIO_FEATURE_CONFIG_FILE_URI.toString());
		
		Map<String,Object> configMap = new HashMap<String,Object>(attributes);
		configMap.put(SimuComConfig.SIMULATE_FAILURES,false);
		configMap.put(SimuComConfig.USE_FIXED_SEED, false);
		configMap.put(SimuComConfig.SIMULATE_LINKING_RESOURCES, getBooleanAttribute(attributes, ConstantsContainer.SIMULATE_LINKING_RESOURCES));
		SimuComConfig simuComConfig = new SimuComConfig(configMap, false);
		//configMap.put(ConstantsContainer.COMPLETION,new HashMap<String, Object>());
		//configMap.put(ConstantsContainer.REVALIDATION, false);
		//simuComWorkflowConfiguration.setCompletionConfiguration(new PCMCompletionRunConfiguration(simuComWorkflowConfiguration, configMap));
		
		simuComWorkflowConfiguration.setSimuComConfiguration(simuComConfig);
		return simuComWorkflowConfiguration;
	}*/
	
	private QVTOTransformationJobConfiguration deriveQvtoConfiguration(Map<String, Object> attributes, IQAlternative alternative) {
		// Creating and setting transformation configuration
		QVTOTransformationJobConfiguration qvtoTransformationJobConfiguration = new QVTOTransformationJobConfiguration();
		String usageModelId = getLocalUsageModelId(alternative);
		setQVTOOptions(qvtoTransformationJobConfiguration, usageModelId);
		qvtoTransformationJobConfiguration.setInoutModels(new ModelLocation[SAMM2PCM_PARAMETER_COUNT]);

		try {
			getInputParameter(alternative, qvtoTransformationJobConfiguration.getInoutModels());
		} catch (JobFailedException e) {
			logger.error("could not determine input parameters for the QVT transformation configuration", e);
		}
		getOutputParameter(alternative, qvtoTransformationJobConfiguration.getInoutModels());

		URI traceFilePath = LoadSAMMAlternativeJob.getURIForQIElement(alternative).
					appendSegment("SAMM2PCM").
					appendSegment("SAMM2PCM.qvtotrace");
		qvtoTransformationJobConfiguration.setTraceFileURI(traceFilePath);
		qvtoTransformationJobConfiguration.setScriptFileURI(SAMM2PCM_QVTO_SCRIPT_FILE_URI);
		
		return qvtoTransformationJobConfiguration;
	}
	
	private String getLocalUsageModelId(IQAlternative alternative) {
		IQModel usage = null;
		try {
			usage = alternative.getModel(RepositoryModels.USAGE_MODEL_EXT);
		} catch (RepositoryException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if (usage == null) {
			return null;
		}
		UsageRepository usageRepository = usage.getTopLevelEObject(UsageRepository.class);
		if ((usageRepository == null) || (usageRepository.getUsageModels() == null) || (usageRepository.getUsageModels().size() == 0)) {
			return null;
		}
		return usageRepository.getUsageModels().get(0).getId();
	}
	

	private static final String[] pcmExtensions = new String[]{
		"repository",
		"system",
		"resourceenvironment",
		"allocation",
		"usagemodel"
	};
	
	private static final int FIRST_OUT_PARAM_POSITION = LoadSAMMAlternativeJob.SAMM_EXTENSIONS.length + 2;

	/**
	 * @param alternative 
	 * @param modelLocations 
	 * 
	 */
	private void getOutputParameter(IQAlternative alternative, ModelLocation[] modelLocations) {
		URI alternativeLocation = LoadSAMMAlternativeJob.getURIForQIElement(alternative);
		for (int i = 0; i < pcmExtensions.length; i++) {
			modelLocations[FIRST_OUT_PARAM_POSITION + i] =
				new ModelLocation(PCM_PARTITION, 
						alternativeLocation.
						appendSegment("SAMM2PCM").
						appendSegment("pcm_output."+pcmExtensions[i]));
		}
	}

	/**
	 * @param qvtoTransformationJobConfiguration
	 */
	private void setQVTOOptions(
			QVTOTransformationJobConfiguration qvtoTransformationJobConfiguration, String usageModelId) {
		Map<String, Object> modelsTransformationOpt = new HashMap<String, Object>();
		modelsTransformationOpt.put("defaultEntityName", "defaultName");
		modelsTransformationOpt.put("defaultHddProcessingRateValue", "1.0");
		modelsTransformationOpt.put("defaultCpuProcessingRateValue", "1.0");
		modelsTransformationOpt.put("defaultNetworkBandwidthValue", "1.0");
		modelsTransformationOpt.put("defaultNetworkLatencyValue", "0.0");
		modelsTransformationOpt.put("systemModelName", "System");
		modelsTransformationOpt.put("allocationModelName", "Service");
		//modelsTransformationOpt.put("usageScenarioModelName", "UsageScenario");
		modelsTransformationOpt.put("usageModelId", usageModelId);
		qvtoTransformationJobConfiguration.setOptions(modelsTransformationOpt);
	}
	
	private static final String SAMM_PARTITION = LoadSAMMIntoBlackboardJob.SAMM_MODELS_PARTITION_ID;
	private static final String PCM_PARTITION = LoadPCMModelsIntoBlackboardJob.PCM_MODELS_PARTITION_ID;
	
	private void getInputParameter(IQAlternative selectedAlternative, ModelLocation[] modelLocations) throws JobFailedException {
		IQModel[] elements = selectedAlternative.getModels();
		int i = 0;
		for (String extension : LoadSAMMAlternativeJob.SAMM_EXTENSIONS) {
			try {
				modelLocations[i++] = 
					new ModelLocation(SAMM_PARTITION,LoadSAMMAlternativeJob.getResourceURI(elements, extension));
			} catch (JobFailedException e) {
				logger.error("model loading failed.", e);
				throw e;
			}
		}
		//i--; //Do not consider the result model as part of the SAMM, this is messy, talk to Luigi for alternatives
		modelLocations[i++] = 
			new ModelLocation(PCM_PARTITION, PCM_PALLADIO_PRIMITIVE_TYPE_REPOSITORY_URI);
		modelLocations[i++] = 
			new ModelLocation(PCM_PARTITION, PCM_PALLADIO_RESOURCE_TYPE_URI);
	}
}
