package eu.qimpress.transformations.samm2pcm;

import java.util.ArrayList;
import java.util.List;

import eu.qimpress.samm.datatypes.CollectionDataType;
import eu.qimpress.samm.datatypes.ComplexDataType;
import eu.qimpress.samm.datatypes.InnerElement;
import eu.qimpress.samm.datatypes.Type;
import eu.qimpress.samm.usagemodel.UsageScenario;

public class Samm2PcmUtil {
	
	//private static StringBuffer myBuffer = new StringBuffer();

	public static String getUsageScenarioSimulationName(UsageScenario scenario) {
		String usageScenarioSimulationName = scenario.getName();
		usageScenarioSimulationName = usageScenarioSimulationName.replaceAll(" ", "_");
		usageScenarioSimulationName = usageScenarioSimulationName.replaceAll("<", "_");
		usageScenarioSimulationName = usageScenarioSimulationName.replaceAll(">", "_");
		usageScenarioSimulationName = usageScenarioSimulationName.replaceAll(":", "_");
		return usageScenarioSimulationName;
	}

	public static String getFileNameForSensor(String sensorName) {
		String fileName = sensorName;
		fileName = fileName.replaceAll(" ", "_");
		fileName = fileName.replaceAll("<", "_");
		fileName = fileName.replaceAll(">", "_");
		fileName = fileName.replaceAll(":", "_");
		fileName = fileName.replaceAll("[.]", "_");
		fileName = fileName.replaceAll(",", "_");
		return fileName;
	}
	
	private static List<Type> ancestorTypes = new ArrayList<Type>();

	public final static Boolean hasNestedTypeCompDataType(ComplexDataType ctype) {
		ancestorTypes.clear();
		if ((ctype == null) || (ctype.getElements() == null) || (ctype.getElements().size() == 0)) {
			return false;
		}
		boolean result = findCyclesComp(ctype);
		// Throw an exception in order to present a message to the user containing all types in the cycle
		if (result) {
			StringBuffer messageString = new StringBuffer("A complex data type must not contain a self reference in a nested data type. Involved types: ");
			for (int i=0; i<ancestorTypes.size(); i++) {
				if (i>0) {
					messageString.append(" | ");
				}
				messageString.append(ancestorTypes.get(i).getName());
			}
			throw new RuntimeException(messageString.toString());
		}
		return result;
	}
	
	public final static Boolean hasNestedTypeCollDataType(CollectionDataType ctype) {
		ancestorTypes.clear();
		if ((ctype == null) || (ctype.getInnertype() == null)) {
			return false;
		}
		boolean result = findCyclesColl(ctype);
		// Throw an exception in order to present a message to the user containing all types in the cycle
		if (result) {
			StringBuffer messageString = new StringBuffer("A collection data type must not contain a self reference in a nested data type. Involved types: ");
			for (int i=0; i<ancestorTypes.size(); i++) {
				if (i>0) {
					messageString.append(" | ");
				}
				messageString.append(ancestorTypes.get(i).getName());
			}
			throw new RuntimeException(messageString.toString());
		}
		return result;
	}
	
	private final static Boolean findCycles(Type type) {
		if (type instanceof CollectionDataType) {
			return findCyclesColl((CollectionDataType)type);
		}
		if (type instanceof ComplexDataType) {
			return findCyclesComp((ComplexDataType)type);
		}
		return false;
	}
	
	private final static Boolean findCyclesComp(ComplexDataType type) {
		if (ancestorTypes.contains(type)) {
			return true;
		}
		ancestorTypes.add(type);
		for (InnerElement innerElement : type.getElements()) {
			if ((innerElement.getType() != null) && findCycles(innerElement.getType())) {
				return true;
			}
		}
		ancestorTypes.remove(type);
		return false;
	}
	
	private final static Boolean findCyclesColl(CollectionDataType type) {
		if (ancestorTypes.contains(type)) {
			return true;
		}
		ancestorTypes.add(type);
		if ((type.getInnertype() != null) && (findCycles(type.getInnertype()))) {
			return true;
		}
		ancestorTypes.remove(type);
		return false;
	}
	
}
