package eu.qimpress.transformations.samm2pcm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.EmfMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelProvider;

public class Samm2PcmMetamodelProvider implements IMetamodelProvider {

	ResourceSet rs = new ResourceSetImpl();
	
	@Override
	public IMetamodelDesc[] getMetamodels() {
		HashMap<URI, URI> uriMapping = new HashMap<URI, URI>();
		List<IMetamodelDesc> mms = new ArrayList<IMetamodelDesc>();
		uriMapping.put(URI.createURI("http://q-impress.eu/samm"), URI.createURI("platform:/plugin/eu.qimpress.samm/model/samm.ecore"));
		uriMapping.put(URI.createURI("http://q-impress.eu/seff"), URI.createURI("platform:/plugin/eu.qimpress.seff/model/seff.ecore"));
		uriMapping.put(URI.createURI("http://q-impress.eu/qualityannotationdecorator"), URI.createURI("platform:/plugin/eu.qimpress.qualityannotationdecorator/model/qualityannotationdecorator.ecore"));
		for (URI u : uriMapping.values()) {
			Resource r = rs.getResource(u, true);
			EPackage ep = (EPackage) r.getContents().get(0);
			mms.add(new EmfMetamodelDesc(ep, ep.getNsURI(), ep.getNsPrefix()));
		}
		return mms.toArray(new IMetamodelDesc[]{});
	}

}
