package eu.qimpress.transformations.rpg2sam.sam;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.usagemodel.ClosedWorkload;
import eu.qimpress.samm.usagemodel.SystemCall;
import eu.qimpress.samm.usagemodel.UsageModel;
import eu.qimpress.samm.usagemodel.UsageRepository;
import eu.qimpress.samm.usagemodel.UsageScenario;
import eu.qimpress.samm.usagemodel.UsagemodelFactory;

public class WorkloadModel
{
	/**
	 * The model container is accessible as a field.
	 */
	public final UsageRepository model = UsagemodelFactory.eINSTANCE.createUsageRepository ();

	/**
	 * The import context for this model.
	 * 
	 * The import context provides links to other models that will be created from the same input.
	 */
	private Importer importer;
	
	/**
	 * The model factory is invoked through a proxy 
	 * that takes care of adding all model elements
	 * to the model container.
	 */
	class FactoryProxy implements InvocationHandler
	{
		@Override
		public Object invoke (Object self, Method method, Object[] arguments) throws Throwable
		{
			Object element = method.invoke (UsagemodelFactory.eINSTANCE, arguments);
			if (element instanceof UsageModel) model.getUsageModels ().add ((UsageModel) element);
			return (element);			
		}
	}
	
	private final UsagemodelFactory factory = (UsagemodelFactory) Proxy.newProxyInstance (
		UsagemodelFactory.eINSTANCE.getClass ().getClassLoader (),
		new Class [] { UsagemodelFactory.class },
		new FactoryProxy ());

	//----------------------------------------------------------------------
	
	protected WorkloadModel (Importer importContext)
	{
		importer = importContext;
		model.setName ("Main");
	}

	protected UsageScenario createUsageScenario (InterfacePort providedPort, int userCount, double thinkTime)
	{
		UsageModel usage = factory.createUsageModel ();
		usage.setName ("Main");
		
		SystemCall invocation = factory.createSystemCall ();
		invocation.setName ("UsageCall");
		invocation.setCalledInterfacePort (providedPort);
		invocation.setOperation (importer.callbackGetOperationType ());
		invocation.setCallProbability (1.0);
		
		ClosedWorkload workload = factory.createClosedWorkload ();
		workload.setName ("UsageWorkload");
		workload.setNumberOfUsers (userCount);
		workload.setThinkTime (thinkTime);
		
		UsageScenario scenario = factory.createUsageScenario ();
		scenario.setName ("UsageScenario");
		scenario.setWorkload (workload);
		scenario.getSystemCalls ().add (invocation);
		usage.getUsageScenarios ().add (scenario);

		return (scenario);
	}
}
