package eu.qimpress.transformations.rpg2sam.sam;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

import eu.qimpress.samm.deployment.targetenvironment.Container;
import eu.qimpress.samm.deployment.targetenvironment.ExecutionResource;
import eu.qimpress.samm.deployment.targetenvironment.Memory;
import eu.qimpress.samm.deployment.targetenvironment.MemoryResource;
import eu.qimpress.samm.deployment.targetenvironment.Node;
import eu.qimpress.samm.deployment.targetenvironment.Processor;
import eu.qimpress.samm.deployment.targetenvironment.SchedulingPolicyKind;
import eu.qimpress.samm.deployment.targetenvironment.TargetEnvironment;
import eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentFactory;

public class HardwareModel
{
	/**
	 * The model container is accessible as a field.
	 */
	public final TargetEnvironment model = TargetenvironmentFactory.eINSTANCE.createTargetEnvironment ();

	// Some fixed constants are used by other model classes.
	
	public static final int SAM_HARDWARE_PROCESSOR_FREQUENCY = 1000000000;
	public static final int SAM_HARDWARE_MEMORY_SIZE = 1000000000;
	
	/**
	 * The import context for this model.
	 * 
	 * The import context provides links to other models that will be created from the same input.
	 */
	private Importer importer;
	
	/**
	 * The model factory is invoked through a proxy 
	 * that takes care of adding all model elements
	 * to the model container.
	 */
	class FactoryProxy implements InvocationHandler
	{
		@Override
		public Object invoke (Object self, Method method, Object[] arguments) throws Throwable
		{
			Object element = method.invoke (TargetenvironmentFactory.eINSTANCE, arguments);
			if (element instanceof Node) model.getNodes ().add ((Node) element);
			return (element);			
		}
	}
	
	private final TargetenvironmentFactory factory = (TargetenvironmentFactory) Proxy.newProxyInstance (
		TargetenvironmentFactory.eINSTANCE.getClass ().getClassLoader (),
		new Class [] { TargetenvironmentFactory.class },
		new FactoryProxy ());

	//----------------------------------------------------------------------
	
	protected HardwareModel (Importer importContext)
	{
		importer = importContext;
		model.setName ("Main");
		
		// Right now, the hardware model is hardcoded.
		
		processorInstance = factory.createProcessor ();
		processorInstance.setName ("DefaultProcessor");
		processorInstance.setClockFrequency (SAM_HARDWARE_PROCESSOR_FREQUENCY);
		processorInstance.setDescriptor (importer.callbackGetProcessorDescriptorSingleton ());

		executionResourceInstance = factory.createExecutionResource ();
		executionResourceInstance.setProcessor (processorInstance);

		memoryInstance = factory.createMemory ();
		memoryInstance.setName ("DefaultMemory");
		memoryInstance.setSize (SAM_HARDWARE_MEMORY_SIZE);
		memoryInstance.setDescriptor (importer.callbackGetMemoryDescriptorSingleton ());

		memoryResourceInstance = factory.createMemoryResource ();
		memoryResourceInstance.setName ("DefaultMemoryResource");
		memoryResourceInstance.setMemory (memoryInstance);
		
		containerInstance = factory.createContainer ();
		containerInstance.setName ("DefaultContainer");
		containerInstance.setSchedulingPolicy (SchedulingPolicyKind.PROCESSOR_SHARING);
		containerInstance.getExecutionResources ().add (executionResourceInstance);
		containerInstance.getMemoryResources ().add (memoryResourceInstance);
		containerInstance.setDescription ("A default container.");
		
		Node node = factory.createNode ();
		node.setName ("DefaultNode");
		node.getContainers ().add (containerInstance);
		node.getProcessors ().add (processorInstance);
		node.getMemories ().add (memoryInstance);
	}

	/*
	 * The singleton models.
	 */
	
	private Processor processorInstance;
	protected Processor getProcessorInstance () { return (processorInstance); }
	
	private ExecutionResource executionResourceInstance;
	protected ExecutionResource getExecutionResourceInstance () { return (executionResourceInstance); }
	
	private Memory memoryInstance;
	protected Memory getMemoryInstance () { return (memoryInstance); }
	
	private MemoryResource memoryResourceInstance;
	protected MemoryResource getMemoryResourceInstance () { return (memoryResourceInstance); }
	
	private Container containerInstance;
	protected Container getContainerInstance () { return (containerInstance); }
}
