package eu.qimpress.transformations.rpg2sam.sam;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

import eu.qimpress.samm.deployment.hardware.HardwareDescriptor;
import eu.qimpress.samm.deployment.hardware.HardwareDescriptorRepository;
import eu.qimpress.samm.deployment.hardware.HardwareFactory;
import eu.qimpress.samm.deployment.hardware.MemoryDescriptor;
import eu.qimpress.samm.deployment.hardware.ProcessorCore;
import eu.qimpress.samm.deployment.hardware.ProcessorDescriptor;
import eu.qimpress.transformations.rpg2sam.rpg.Measurements;

public class DomainModel
{
	/**
	 * The model container is accessible as a field.
	 */
	public final HardwareDescriptorRepository model = HardwareFactory.eINSTANCE.createHardwareDescriptorRepository ();

	/**
	 * The import context for this model.
	 * 
	 * The import context provides links to other models that will be created from the same input.
	 */
	private Importer importer;
	
	/**
	 * The model factory is invoked through a proxy 
	 * that takes care of adding all model elements
	 * to the model container.
	 */
	class FactoryProxy implements InvocationHandler
	{
		@Override
		public Object invoke (Object self, Method method, Object[] arguments) throws Throwable
		{
			Object element = method.invoke (HardwareFactory.eINSTANCE, arguments);
			if (element instanceof HardwareDescriptor) model.getDescriptors ().add ((HardwareDescriptor) element);
			return (element);			
		}
	}
	
	private final HardwareFactory factory = (HardwareFactory) Proxy.newProxyInstance (
		HardwareFactory.eINSTANCE.getClass ().getClassLoader (),
		new Class [] { HardwareFactory.class },
		new FactoryProxy ());

	//----------------------------------------------------------------------
	
	protected DomainModel (Importer importContext) throws Exception
	{
		importer = importContext;
		model.setName ("Main");
		
		// Right now, the domain model is mostly hardcoded.
		
		memoryDescriptorInstance = factory.createMemoryDescriptor ();
		memoryDescriptorInstance.setName ("DefaultMemory");

		processorDescriptorInstance = factory.createProcessorDescriptor ();
		processorDescriptorInstance.setName ("DefaultProcessor");
		
		int coreCount = (int) Math.round (importer.measurements.getGlobalAverage (Measurements.RPG_MEASUREMENT_ATTRIBUTE_CORES));
		
		for (int core = 0 ; core < coreCount ; core ++)
		{
			ProcessorCore processorCoreInstance = factory.createProcessorCore ();
			processorCoreInstance.setName ("ProcessorCore" + core);

			processorDescriptorInstance.getCores ().add (processorCoreInstance);
		}
	}
	
	private ProcessorDescriptor processorDescriptorInstance;
	protected ProcessorDescriptor getProcessorDescriptorInstance () { return (processorDescriptorInstance); }
	
	private MemoryDescriptor memoryDescriptorInstance;
	protected MemoryDescriptor getMemoryDescriptorInstance () { return (memoryDescriptorInstance); }
}
