package eu.qimpress.transformations.rpg2sam.sam;

import eu.qimpress.samm.deployment.allocation.AllocationFactory;
import eu.qimpress.samm.deployment.allocation.Service;
import eu.qimpress.samm.staticstructure.ComponentEndpoint;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.Connector;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.ServiceArchitectureModel;
import eu.qimpress.samm.staticstructure.StaticstructureFactory;
import eu.qimpress.samm.staticstructure.SubcomponentEndpoint;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;

public class DeploymentModel
{
	/**
	 * The model container is accessible as a field.
	 */
	public final ServiceArchitectureModel model = StaticstructureFactory.eINSTANCE.createServiceArchitectureModel ();

	/**
	 * The import context for this model.
	 * 
	 * The import context provides links to other models that will be created from the same input.
	 */
	private Importer importer;
	
	//----------------------------------------------------------------------
	
	protected DeploymentModel (Importer importContext)
	{
		importer = importContext;
		model.setName ("Main");
	}

	protected void createServices (ComponentType rootComponentType, ComponentType poolComponentType)
	{
		SubcomponentInstance rootComponent = StaticstructureFactory.eINSTANCE.createSubcomponentInstance ();
		rootComponent.setName ("Root");
		rootComponent.setRealizedBy (rootComponentType);
		model.getSubcomponents ().add (rootComponent);

		SubcomponentInstance poolComponent = StaticstructureFactory.eINSTANCE.createSubcomponentInstance ();
		poolComponent.setName ("Pool");
		poolComponent.setRealizedBy (poolComponentType);
		model.getSubcomponents ().add (poolComponent);

		InterfacePort rootProvidedPort = rootComponentType.getProvided ().get (0);
		InterfacePort poolProvidedPort = poolComponentType.getProvided ().get (0);
		InterfacePort poolRequiredPort = poolComponentType.getRequired ().get (0);
		
		InterfacePort outsidePort = StaticstructureFactory.eINSTANCE.createInterfacePort ();
		outsidePort.setInterfaceType (poolProvidedPort.getInterfaceType ());
		outsidePort.setName (poolProvidedPort.getName ());
		model.getProvided ().add (outsidePort);
		
		Connector outsideConnector = StaticstructureFactory.eINSTANCE.createConnector ();
		ComponentEndpoint outsideEndpoint = StaticstructureFactory.eINSTANCE.createComponentEndpoint ();
		outsideEndpoint.setPort (outsidePort);
		outsideConnector.getEndpoints ().add (outsideEndpoint);
		SubcomponentEndpoint poolProvidedEndpoint = StaticstructureFactory.eINSTANCE.createSubcomponentEndpoint ();
		poolProvidedEndpoint.setSubcomponent (poolComponent);
		poolProvidedEndpoint.setPort (poolProvidedPort);
		outsideConnector.getEndpoints ().add (poolProvidedEndpoint);
		model.getConnector ().add (outsideConnector);
	
		Connector insideConnector = StaticstructureFactory.eINSTANCE.createConnector ();
		SubcomponentEndpoint poolRequiredEndpoint = StaticstructureFactory.eINSTANCE.createSubcomponentEndpoint ();
		poolRequiredEndpoint.setSubcomponent (poolComponent);
		poolRequiredEndpoint.setPort (poolRequiredPort);
		insideConnector.getEndpoints ().add (poolRequiredEndpoint);
		SubcomponentEndpoint rootProvidedEndpoint = StaticstructureFactory.eINSTANCE.createSubcomponentEndpoint ();
		rootProvidedEndpoint.setSubcomponent (rootComponent);
		rootProvidedEndpoint.setPort (rootProvidedPort);
		insideConnector.getEndpoints ().add (rootProvidedEndpoint);
		model.getConnector ().add (insideConnector);
	
		Service poolService = AllocationFactory.eINSTANCE.createService ();
		poolService.setName ("Pool");
		poolService.setIsBlackBox (false);
		poolService.setSubcomponentInstance (poolComponent);
		poolService.setContainer (importer.callbackGetContainerSingleton ());
		model.getService ().add (poolService);

		Service rootService = AllocationFactory.eINSTANCE.createService ();
		rootService.setName ("Root");
		rootService.setIsBlackBox (false);
		rootService.setSubcomponentInstance (rootComponent);
		rootService.setContainer (importer.callbackGetContainerSingleton ());
		model.getService ().add (rootService);
	}
}
