package eu.qimpress.transformations.rpg2sam.ide;

import java.io.File;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.statushandlers.StatusManager;

import eu.qimpress.ide.backbone.core.model.IQAlternative;

public class ImportWizardSingle extends ImportWizard
{
	public boolean performFinish ()
	{
        try
        {
        	// Get the common import configuration from the user interface. 
        	final Configuration configuration = configureImport ();
        	
        	// Get the selected alternative and the model files from the user interface.  
        	IQAlternative alternative;
        	
        	if ((navigatorSelection.size () == 1) &&
        		(navigatorSelection.getFirstElement () instanceof IQAlternative))
        	{
        		alternative = (IQAlternative) navigatorSelection.getFirstElement ();
        	}
        	else throw new Exception ("A single alternative to import into must be selected.");
        	
        	final String directoryName = selectionPage.directoryText.getText ();
        	String architectureName = directoryName + File.separator + RPG_ARCHITECTURE_FILE;
        	String measurementsName = directoryName + File.separator + RPG_MEASUREMENTS_FILE;

        	performImport (alternative, architectureName, measurementsName, configuration);
        }
        catch (Exception e)
        {
        	// Report errors in a blocking manner.
        	Status status = new Status (IStatus.ERROR, PLUGIN_ID, "Import of the architecture has failed.", e);
        	StatusManager.getManager ().handle (status, StatusManager.LOG | StatusManager.BLOCK);
        }
		
        // FIXME Refresh the navigator view.
        
		return (true);
	}

	public void init (IWorkbench workbench, IStructuredSelection selection)
	{
		// Save the selection for later.
		navigatorSelection = selection;
		
		// Create the wizard page. 
		setWindowTitle ("RPG Architecture Import Wizard");
		selectionPage = new ImportWizardPage ("Import RPG Architecture", "Import an RPG architecture description file from the local file system into the selected alternative.");
	}

	public void addPages ()
	{
		super.addPages ();
		
		// We only have a single page.
		addPage (selectionPage);
	}
}
