package eu.qimpress.transformations.rpg2sam.ide;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ImportWizardPage extends WizardPage
{
	private static String directoryLast = "";
	private static String depthLast = "0";
	
	protected Text directoryText;
	protected Text depthText;
	protected Button measurementsButtonRandom;
	protected Button measurementsButtonMeasured;
	protected Button timingButtonShared;
	protected Button timingButtonIsolated;
	protected Button annotationButtonMeans;
	protected Button annotationButtonDistributions;

	public ImportWizardPage (String pageName, String pageDescription)
	{
		super (pageName);
		setTitle (pageName);
		setDescription (pageDescription);
	}

	public void createControl (Composite parent)
	{
		// We will use functions that measure text, dialog units must be initialized before that.
		initializeDialogUnits (parent);
		
		Composite selectionArea = new Composite (parent, SWT.NONE);
		
		selectionArea.setLayout (new GridLayout ());
		selectionArea.setLayoutData (new GridData (SWT.FILL, SWT.FILL, true, true));

		// The directory area.
		// Contains a label, a text widget for input, and a button for selector.
		
		Composite directoryArea = new Composite (selectionArea, SWT.NONE);
		directoryArea.setLayout (new GridLayout (3, false));
		directoryArea.setLayoutData (new GridData (SWT.FILL, SWT.CENTER, true, false));
		
		Label directoryLabel = new Label (directoryArea, SWT.NONE);
		directoryLabel.setText ("Select architecture directory: ");
		
		directoryText = new Text (directoryArea, SWT.BORDER);
		directoryText.setLayoutData (new GridData (SWT.FILL, SWT.CENTER, true, false));
		directoryText.setText (directoryLast);
		
		Button directoryButton = new Button (directoryArea, SWT.PUSH);
		directoryButton.setText ("Br&owse");
		directoryButton.addSelectionListener (new SelectionAdapter ()
		{
			public void widgetSelected (SelectionEvent e)
			{
                DirectoryDialog dialog = new DirectoryDialog (directoryText.getShell ());
                dialog.setFilterPath (directoryText.getText ());
                String directory = dialog.open ();
                if (directory != null)
                {
                	directoryLast = directory;
                	directoryText.setText (directory);
                }
			}
		});
		setButtonLayoutData (directoryButton);
		
		// The measurement options area.
		// Contains a label, and radio buttons for input.
		
		Composite measurementsOptionArea = new Composite (selectionArea, SWT.NONE);
		measurementsOptionArea.setLayout (new GridLayout (1, false));
		measurementsOptionArea.setLayoutData (new GridData (SWT.FILL, SWT.CENTER, true, false));

		measurementsButtonRandom = new Button (measurementsOptionArea, SWT.RADIO);
		measurementsButtonRandom.setText ("Generate &random values");
		measurementsButtonMeasured= new Button (measurementsOptionArea, SWT.RADIO);
		measurementsButtonMeasured.setText ("Use &measured values");

		measurementsButtonMeasured.setSelection (true);

		// The timing options area.
		// Contains a label, and radio buttons for input.
		
		Composite timingOptionArea = new Composite (selectionArea, SWT.NONE);
		timingOptionArea.setLayout (new GridLayout (1, false));
		timingOptionArea.setLayoutData (new GridData (SWT.FILL, SWT.CENTER, true, false));

		timingButtonShared = new Button (timingOptionArea, SWT.RADIO);
		timingButtonShared.setText ("Use timing values from a &shared context");
		timingButtonIsolated = new Button (timingOptionArea, SWT.RADIO);
		timingButtonIsolated.setText ("Use timing values from an &isolated context");

		timingButtonIsolated.setSelection (true);
		
		// The annotation options area.
		// Contains a label, and radio buttons for input.
		
		Composite annotationOptionArea = new Composite (selectionArea, SWT.NONE);
		annotationOptionArea.setLayout (new GridLayout (1, false));
		annotationOptionArea.setLayoutData (new GridData (SWT.FILL, SWT.CENTER, true, false));

		annotationButtonMeans= new Button (annotationOptionArea, SWT.RADIO);
		annotationButtonMeans.setText ("Use annotations based on &average values");
		annotationButtonDistributions = new Button (annotationOptionArea, SWT.RADIO);
		annotationButtonDistributions.setText ("Use annotations based on &empirical distributions");

		annotationButtonDistributions.setSelection (true);
		
		// The import depth area.
		// Contains a label and a text widget for input.
		
		Composite depthArea = new Composite (selectionArea, SWT.NONE);
		depthArea.setLayout (new GridLayout (2, false));
		depthArea.setLayoutData (new GridData (SWT.FILL, SWT.CENTER, true, false));
		
		Label depthLabel = new Label (depthArea, SWT.NONE);
		depthLabel.setText ("&Limit maximum depth: ");
		
		depthText = new Text (depthArea, SWT.BORDER);
		depthText.setLayoutData (new GridData (SWT.FILL, SWT.CENTER, true, false));
		depthText.setText (depthLast);
		
		// TODO We should probably validate the directory name.

		setControl (selectionArea);
	}
}
