package eu.qimpress.transformations.rpg2sam.ide;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.statushandlers.StatusManager;

import eu.qimpress.ide.backbone.core.model.IQAlternative;

public class ImportWizardMultiple extends ImportWizard
{
	public ImportWizardMultiple ()
	{
		super ();
		
		// Ask for a progress monitor.
		// This must be in constructor.
		setNeedsProgressMonitor (true);

	}
	public boolean performFinish ()
	{
        try
        {
        	// Get the common import configuration from the user interface. 
        	final Configuration configuration = configureImport ();
        	
        	// Get the selected alternative and the model directories from the user interface.  
        	final IQAlternative parentAlternative;
        	
        	if ((navigatorSelection.size () == 1) &&
        		(navigatorSelection.getFirstElement () instanceof IQAlternative))
        	{
        		parentAlternative = (IQAlternative) navigatorSelection.getFirstElement ();
        	}
        	else throw new Exception ("A single alternative to import into must be selected.");

        	// We search all subdirectories for architecture description files.
        	// Every discovered file is imported into a new alternative.
        	final String directoryName = selectionPage.directoryText.getText ();
        	final File directoryFile = new File (directoryName);
        	final File subdirectoryFiles [] = directoryFile.listFiles ();
        	Arrays.sort (subdirectoryFiles);
        	
        	// The rest of the import happens in a runnable with progress monitor.
        	
         	getContainer ().run (
        		true,
        		true,
        		new IRunnableWithProgress ()
				{
					@Override
					public void run (IProgressMonitor monitor) throws InvocationTargetException, InterruptedException
					{
						// Remember whether to report failure eventually.
						boolean reportFailure = false;
						
						try
						{
				        	monitor.beginTask ("Importing multiple RPG architecture files", subdirectoryFiles.length + 1);
				        	monitor.worked (1);

				        	for (File subdirectoryFile : subdirectoryFiles)
				        	{
				        		if (monitor.isCanceled ()) break;
				        		monitor.subTask (subdirectoryFile.getName () + ".");
				        		
				        		if (subdirectoryFile.isDirectory ())
				        		{
				                	String architectureName = subdirectoryFile.getPath () + File.separator + RPG_ARCHITECTURE_FILE;
				                	String measurementsName = subdirectoryFile.getPath () + File.separator + RPG_MEASUREMENTS_FILE;
	
				                	IQAlternative childAlternative = parentAlternative.getRepository ().createAlternative (parentAlternative, subdirectoryFile.getName (), true);

				                	try
				                	{
				                		performImport (childAlternative, architectureName, measurementsName, configuration);
				                	}
				                	catch (Exception e)
				                	{
				                		// Exceptions during import are logged.
				                		Status status = new Status (IStatus.ERROR, PLUGIN_ID, "Import of " + subdirectoryFile.getName () + " failed.", e);
				                		StatusManager.getManager ().handle (status, StatusManager.LOG);
				                		reportFailure = true;
				                	}
				        		}
				        		
				        		monitor.worked (1);
				        	}
				        	
							if (reportFailure) throw new Exception ("Check error log for details.");
						}
						catch (Exception e)
						{
							throw new InvocationTargetException (e, e.getMessage ());
						}
						finally
						{
				        	monitor.done ();
						}
					}
				});
        }
        catch (Exception e)
        {
        	// Report errors in a blocking manner.
        	Status status = new Status (IStatus.ERROR, PLUGIN_ID, "Import of some architectures has failed.", e);
        	StatusManager.getManager ().handle (status, StatusManager.LOG | StatusManager.BLOCK);
        }
		
        // FIXME Refresh the navigator view.
        
		return (true);
	}

	public void init (IWorkbench workbench, IStructuredSelection selection)
	{
		// Save the selection for later.
		navigatorSelection = selection;
		// Create the wizard page. 
		setWindowTitle ("RPG Architecture Import Wizard");
		selectionPage = new ImportWizardPage ("Import Multiple RPG Architectures", "Import multiple RPG architecture description files from the local file system into the selected alternative.");
	}

	public void addPages ()
	{
		super.addPages ();
		
		// We only have a single page.
		addPage (selectionPage);
	}
}
