package eu.qimpress.transformations.rpg2sam.ide;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.RepositoryModels;
import eu.qimpress.transformations.rpg2sam.ide.Configuration.MeasurementAnnotationSelection;
import eu.qimpress.transformations.rpg2sam.ide.Configuration.TimingSourceSelection;
import eu.qimpress.transformations.rpg2sam.ide.Configuration.ValueSourceSelection;
import eu.qimpress.transformations.rpg2sam.sam.Importer;

public abstract class ImportWizard extends Wizard implements IImportWizard
{
	/** The page with the file selector dialog.
	 */
	protected ImportWizardPage selectionPage;

	/** The selection in the navigator window pane.
	 */
	protected IStructuredSelection navigatorSelection;

	private static final String RPG_MODEL_FILE = "main";

	protected static final String PLUGIN_ID = "RPG2SAM";
	
	protected static final String RPG_ARCHITECTURE_FILE = "main.xml";
	protected static final String RPG_MEASUREMENTS_FILE = "main.out";

	/** Creates an import configuration from the dialog settings.
	 * 
	 * The method to create the import configuration is separated from the method to perform
	 * the actual import because the access to the dialog settings might have limitations
	 * on the thread model. 
	 */
	protected Configuration configureImport ()
	{
		Configuration configuration = new Configuration ();
		
		if (selectionPage.measurementsButtonRandom.getSelection ())
		{ configuration.valueSourceSelection = ValueSourceSelection.USE_RANDOM; }
		else if (selectionPage.measurementsButtonMeasured.getSelection ())
		{ configuration.valueSourceSelection = ValueSourceSelection.USE_MEASURED; }
		else throw new AssertionError ("An impossible configuration option value.");
			
		if (selectionPage.timingButtonShared.getSelection ())
		{ configuration.timingSourceSelection = TimingSourceSelection.USE_SHARED; }
		else if (selectionPage.timingButtonIsolated.getSelection ())
		{ configuration.timingSourceSelection = TimingSourceSelection.USE_ISOLATED; }
		else throw new AssertionError ("An impossible configuration option value.");
		
		if (selectionPage.annotationButtonMeans.getSelection ())
		{ configuration.measurementAnnotationSelection = MeasurementAnnotationSelection.USE_MEANS; }
		else if (selectionPage.annotationButtonDistributions.getSelection ())
		{ configuration.measurementAnnotationSelection = MeasurementAnnotationSelection.USE_DISTRIBUTIONS; }
		else throw new AssertionError ("An impossible configuration option value.");
		
		String depthString = selectionPage.depthText.getText ();
		int depthNumber = Integer.parseInt (depthString);
		configuration.maximumDepth = depthNumber;
		
		return (configuration);
	}

	/** Imports the architecture into an alternative.
	 * 
	 * The method to create the import configuration is separated from the method to perform
	 * the actual import because the access to the dialog settings might have limitations
	 * on the thread model.
	 *  
	 * @param alternative The alternative to import into. Existing content overwritten.
	 * @param architectureName The architecture file name.
	 * @param measurementsName The measurements file name.
	 * @param configuration The import configuration.
	 */
	protected void performImport (IQAlternative alternative, String architectureName, String measurementsName, Configuration configuration) throws Exception
	{
		Importer importer = new Importer (architectureName, measurementsName, configuration);

		// An important thing to remember when storing the models is that order is important.
		// When targets are not stored before references, the references are invalid.
		
		alternative.storeEObject (new EObject [] { importer.domainModel.model,
												   importer.hardwareModel.model,
												   importer.architectureModel.model,
												   importer.behaviorModel.model,
												   importer.annotationsModel.model,
												   importer.deploymentModel.model,
												   importer.usageModel.model },
			                      new String [] { ImportWizard.RPG_MODEL_FILE,
									    		  ImportWizard.RPG_MODEL_FILE,
									    		  ImportWizard.RPG_MODEL_FILE,
									    		  ImportWizard.RPG_MODEL_FILE,
									    		  ImportWizard.RPG_MODEL_FILE,
									    		  ImportWizard.RPG_MODEL_FILE,
									    		  ImportWizard.RPG_MODEL_FILE },
			                      new String [] { RepositoryModels.HARDWARE_MODEL_EXT,
												  RepositoryModels.TARGET_ENVIRONMENT_MODEL_EXT,
						                          RepositoryModels.REPOSITORY_MODEL_EXT,
						                          RepositoryModels.SEFF_BEHAVIOR_MODEL_EXT,
						                          RepositoryModels.ANNOTATION_MODEL_EXT,
						                          RepositoryModels.SERVICE_ARCHITECTURE_MODEL_EXT,
						                          RepositoryModels.USAGE_MODEL_EXT });
	}	
}
