package eu.qimpress.transformations.rpg2sam.ide;

/**
 * A class that holds the configuration for the active transformation.
 *
 */
public class Configuration
{
	public static enum ValueSourceSelection { USE_RANDOM, USE_MEASURED };
	public static enum TimingSourceSelection { USE_SHARED, USE_ISOLATED };
	public static enum MeasurementAnnotationSelection { USE_MEANS, USE_DISTRIBUTIONS };
	
	public ValueSourceSelection valueSourceSelection;
	public TimingSourceSelection timingSourceSelection;
	public MeasurementAnnotationSelection measurementAnnotationSelection;
	
	/** Maximum import depth.
	 * 
	 * The import algorithm coalesces the architectures to make sure
	 * no leaf component exists beyond the maximum import depth.
	 * 
	 * Zero means unlimited maximum import depth.
	 */
	public int maximumDepth;
}
