package eu.qimpress.transformations.common.jobs;

import de.uka.ipd.sdq.errorhandling.SeverityEnum;
import de.uka.ipd.sdq.workflow.OrderPreservingBlackboardCompositeJob;
import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedRunConfiguration;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.emf.CheckEMFConstraintsJob;
import de.uka.ipd.sdq.workflow.mdsd.oaw.PerformOAWCheckValidation;
import de.uka.ipd.sdq.workflow.mdsd.validation.ModelValidationJob;
import de.uka.ipd.sdq.workflow.mdsd.validation.ShowValidationErrorsJob;

public class SAMMValidationJob
extends OrderPreservingBlackboardCompositeJob<MDSDBlackboard>{
	
	public static final String OAW_CORE_SAMM_CHECK_FILE = "samm";
	
	public SAMMValidationJob(AbstractWorkflowBasedRunConfiguration configuration,
			String...oawCheckFiles) {
		super();
		this.setName("Checking PCM model constraints");
		for (String oawCheckFile : oawCheckFiles) {
			this.addJob(new PerformOAWCheckValidation(
					LoadSAMMIntoBlackboardJob.SAMM_MODELS_PARTITION_ID, 
					oawCheckFile, 
					LoadSAMMIntoBlackboardJob.SAMM_EPACKAGES));
		}
		this.addJob(new CheckEMFConstraintsJob(SeverityEnum.ERROR,LoadSAMMIntoBlackboardJob.SAMM_MODELS_PARTITION_ID));
		this.addJob(new ShowValidationErrorsJob(configuration, this.toArray(new ModelValidationJob[]{})));
	}

}
