package eu.qimpress.transformations.common.jobs;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;

public class PrepareSAMMBlackboardPartionJob 
implements IJob, IBlackboardInteractingJob<MDSDBlackboard> {
	
	private static final Logger logger = Logger.getLogger(PrepareSAMMBlackboardPartionJob.class);
	private MDSDBlackboard blackboard;

	@Override
	public void execute(IProgressMonitor monitor) throws JobFailedException,
			UserCanceledException {
		// Create and add the SAMM model partition
		logger.debug("Creating SAMM Model Partition");
		ResourceSetPartition myPartion = new ResourceSetPartition();
		this.blackboard.addPartition(LoadSAMMIntoBlackboardJob.SAMM_MODELS_PARTITION_ID, myPartion);
		
		logger.debug("Initialising SAMM EPackages");
		myPartion.initialiseResourceSetEPackages(LoadSAMMIntoBlackboardJob.SAMM_EPACKAGES);
	}

	@Override
	public String getName() {
		return "Prepare SAMM Blackboard Partions";
	}

	@Override
	public void rollback(IProgressMonitor monitor)
			throws RollbackFailedException {
		this.blackboard.removePartition(LoadSAMMIntoBlackboardJob.SAMM_MODELS_PARTITION_ID);
	}

	@Override
	public void setBlackboard(MDSDBlackboard blackboard) {
		this.blackboard = blackboard;
	}

}
