package eu.qimpress.transformations.common.jobs;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EPackage;

import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import eu.qimpress.resultmodel.ResultModelPackage;

public class PrepareResultsBlackboardPartionJob 
implements IJob, IBlackboardInteractingJob<MDSDBlackboard> {
	
	private static final Logger logger = Logger.getLogger(PrepareResultsBlackboardPartionJob.class);
	
	/** The job name */
	private static final String JOB_NAME = "Prepare Results Blackboard Partions";
	
	/** The partition name */
	public static final String PARTITION_ID = "eu.qimpress.results.partition";
	
	/** The packages needed by the reliability models partition*/
	public static final EPackage[] RESULTS_EPACKAGES = new EPackage[] {
		ResultModelPackage.eINSTANCE
	};
	
	/** The blackboard */
	private MDSDBlackboard blackboard;

	@Override
	public void execute(IProgressMonitor monitor) throws JobFailedException,
			UserCanceledException {
		// Create and add the PCM and middleware model partition
		logger.debug("Creating Results Model Partition");
		ResourceSetPartition myPartion = new ResourceSetPartition();
		this.blackboard.addPartition(PrepareResultsBlackboardPartionJob.PARTITION_ID, myPartion);
		
		logger.debug("Initialising Results EPackages");
		myPartion.initialiseResourceSetEPackages(PrepareResultsBlackboardPartionJob.RESULTS_EPACKAGES);
	}

	@Override
	public String getName() {
		return JOB_NAME;
	}

	@Override
	public void rollback(IProgressMonitor monitor)
			throws RollbackFailedException {
		this.blackboard.removePartition(LoadSAMMIntoBlackboardJob.SAMM_MODELS_PARTITION_ID);
	}

	@Override
	public void setBlackboard(MDSDBlackboard blackboard) {
		this.blackboard = blackboard;
	}
}
