package eu.qimpress.transformations.common.jobs;

import org.eclipse.emf.ecore.EPackage;

import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.OrderPreservingBlackboardCompositeJob;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.samm.core.CorePackage;
import eu.qimpress.samm.datatypes.DatatypesPackage;
import eu.qimpress.samm.deployment.hardware.HardwarePackage;
import eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage;
import eu.qimpress.samm.qosannotation.QosannotationPackage;
import eu.qimpress.samm.staticstructure.StaticstructurePackage;
import eu.qimpress.samm.usagemodel.UsagemodelPackage;
import eu.qimpress.seff.seffPackage;
import eu.qimpress.qualityannotationdecorator.seffdecorator.SeffdecoratorPackage;

public class LoadSAMMIntoBlackboardJob
extends OrderPreservingBlackboardCompositeJob<MDSDBlackboard>
implements IJob, IBlackboardInteractingJob<MDSDBlackboard> {

	public static final String SAMM_MODELS_PARTITION_ID = "eu.qimpress.samm.partition";
	public static final EPackage[] SAMM_EPACKAGES = new EPackage[] {
		CorePackage.eINSTANCE,
		DatatypesPackage.eINSTANCE,
		StaticstructurePackage.eINSTANCE,
		HardwarePackage.eINSTANCE,
		TargetenvironmentPackage.eINSTANCE,
		QosannotationPackage.eINSTANCE,
		UsagemodelPackage.eINSTANCE,
		seffPackage.eINSTANCE,
		SeffdecoratorPackage.eINSTANCE
	};

	public LoadSAMMIntoBlackboardJob(IQAlternative alternative) {
		super();
		this.addJob(new PrepareSAMMBlackboardPartionJob());
		this.addJob(new LoadSAMMAlternativeJob(alternative));
	}
}
