package eu.qimpress.transformations.common.jobs;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;

import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.RepositoryException;

public class LoadResultsModelJob implements IJob,
		IBlackboardInteractingJob<MDSDBlackboard> {

	private static final Logger logger = Logger.getLogger(LoadResultsModelJob.class);
	
	/** The job name */
	private static final String JOB_NAME = "Load Results Models into Blackboard Partions";
	
	/** The blackboard */
	private MDSDBlackboard blackboard;
	
	/** The SAMM alternative */
	private IQAlternative alternative;

	public LoadResultsModelJob(IQAlternative alternative) {
		super();
		
		this.alternative = alternative;
	}

	@Override
	public void execute(IProgressMonitor monitor) throws JobFailedException,
			UserCanceledException {
		ResourceSetPartition partition = 
			blackboard.getPartition(PrepareResultsBlackboardPartionJob.PARTITION_ID);
		
		logger.info("Loading Results Model Files");
		IQModel model = null;
		try {
			model = alternative.getRepository().getResultModel();
		} catch (RepositoryException e) {
			logger.error("Failed to load Result Model file.", e);
			return;
		}
		
		URI location = getURIForQIElement(model);
		logger.debug("Loading Result model file " + location);
		partition.loadModel(location);
		
		partition.resolveAllProxies();
	}

	@Override
	public String getName() {
		return JOB_NAME;
	}

	@Override
	public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
		// nothing to do for now
	}

	@Override
	public void setBlackboard(MDSDBlackboard blackboard) {
		this.blackboard = blackboard;
	}

	//TODO remove this code clone
	public static URI getURIForQIElement(IQElement elem) {
		URI location = URI.createURI(elem.getCorrespondingResource().getLocationURI().toString());
		return location;
	}
}
