package eu.qimpress.ide.analysis.reliability.rmc.importer.dtmc;

import java.util.ArrayList;
import java.util.List;

import eu.qimpress.ide.analysis.reliability.rmc.core.*;
import junit.framework.TestCase;

public class TransformationTest extends TestCase {
	
	public void testModelName() throws NumberFormatException, NodeInstantiationException, NodeNotFoundException, ProbabilityException, ModuleInstantiationException {
		assertEquals(new DtmcModelStub(null).getName(), (new Transfomation()).generateRMC(new DtmcModelStub(new ArrayList<IDtmcModule>())).name);
	}
	public void testModelModule() throws NumberFormatException, NodeInstantiationException, NodeNotFoundException, ProbabilityException, ModuleInstantiationException {
		DtmcModuleStub m1 = new DtmcModuleStub(true);
		DtmcModuleStub m2 = new DtmcModuleStub(false);
		ArrayList<IDtmcModule> modules = new ArrayList<IDtmcModule>();
		modules.add(m1);
		modules.add(m2);	

		Transfomation t = new Transfomation();
		RMC rmc = t.generateRMC(new DtmcModelStub(modules));
		assertEquals(2, rmc.getModules().size());
		assertEquals(2, t.modules.size());
		assertNotNull(rmc.getInitialModule());
		assertEquals("module", rmc.getInitialModule().getName());
	}
	public void baseModelWithOneModuleContainingAStartAndAnEnd() throws NumberFormatException, NodeInstantiationException, NodeNotFoundException, ProbabilityException, ModuleInstantiationException {
		(new Transfomation()).mapModule(new RMC(null), new DtmcModuleStub(true), new Module("test"));
	}
}
class DtmcNodeStub implements IDtmcNode {
	@Override
	public List<IDtmcTransition> getInTransitions() {
		return null;
	}
	@Override
	public String getName() {
		return null;
	}
	@Override
	public List<IDtmcTransition> getOutTransitions() {
		return null;
	}
	@Override
	public boolean isEndNode() {
		return false;
	}
	@Override
	public boolean isFailNode() {
		return false;
	}
	@Override
	public boolean isStartNode() {
		return false;
	}
}
class DtmcModelStub implements IDtmcModel {
	private List<IDtmcModule> modules;
	public DtmcModelStub(List<IDtmcModule> arrayList) {
		this.modules=arrayList;
	}
	public List<IDtmcModule> getModules() {
		return modules;
	}
	public String getName() {
		return "test";
	}
}
class DtmcModuleStub implements IDtmcModule {
	private boolean isAutonomous;
	public DtmcModuleStub(boolean isAutonomous) {
		this.isAutonomous = isAutonomous;
	}
	@Override
	public String getName() {
		return "module";
	}
	@Override
	public List<IDtmcNode> getNodes() {
		return new ArrayList<IDtmcNode>();
	}
	@Override
	public List<IDtmcTransition> getTransitions() {
		return new ArrayList<IDtmcTransition>();
	}
	@Override
	public boolean isAutonomous() {
		return isAutonomous;
	}
};