package eu.qimpress.ide.analysis.reliability.rmc.importer.dtmc;

import eu.qimpress.dtmc.CallTransition;
import eu.qimpress.dtmc.Transition;

public class DtmcTransition implements IDtmcTransition {
	private Transition transition;
	private ModelMap map;

	public DtmcTransition(ModelMap map, Transition transition) {
		this.map = map;
		this.transition = transition;
	}
	public String getProbability() {
		return transition.getProbability();
	}
	public IDtmcNode get_to() {
		return map.dtmcNode(transition.get_to());
	}
	public IDtmcNode get_from() {
		return map.dtmcNode(transition.get_from());
	}
	public boolean callModule() {
		return transition instanceof CallTransition;
	}
	public IDtmcModule getCalleeModule() {
		return map.dtmcModule(((CallTransition)transition).getInvokedTransition().getModule());
	}
}
