/**
 * 
 */
package eu.qimpress.ide.analysis.reliability.rmc.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import eu.qimpress.ide.analysis.reliability.rmc.core.*;
import eu.qimpress.ide.analysis.reliability.rmc.mat.*;

/**
 * @author anfi
 */
public class RMC {
	public String name;
	private Set<Module> modules;
	private Module initial;
	private Set<String> equations;
	
	public RMC(String name){
		this.name=""+name;
		this.modules=new TreeSet<Module>();
		this.equations=new TreeSet<String>();
	}
	
	public boolean validate(){
		for(Module m: this.modules){
			if(!m.validate())
				return false;
		}
		return true;
	}
	
	public Module getInitialModule(){
		return this.initial;
	}
	
	public Set<Module> getModules(){
		return this.modules;
	}
	
	public void addModule(Module m,boolean initial){
		this.modules.add(m);
		if(initial){
			this.initial=m;
		}
	}
	
	public Set<String> getEquations(){
		return this.equations;
	}
	
	public void computeEquations() throws NodeNotFoundException{
		for(Module m : this.modules){
			m.computeEquations();
			boolean op=this.equations.addAll(m.getEquations());
			if(!op){
				System.err.println("Something went wrong with module "+m.getName()+" .");
			}
		}
	}
	public List<RmcEquation> getRmcEquations(RmcVariables inputVariables){
		ArrayList<RmcEquation> equations = new ArrayList<RmcEquation>();
		for(Module m: this.modules) {
			for(RmcEquation eq: m.getRmcEquations(inputVariables)) {
				equations.add(eq);
			}
		}
		return equations;
	}
}
