/**
 * 
 */
package eu.qimpress.ide.analysis.reliability.preference;

import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import eu.qimpress.ide.analysis.reliability.Activator;

/**
 * A preference page to set the Prism Model checker properties.
 * @author Mauro Luigi Drago
 *
 */
public class PrismPreferencePage extends FieldEditorPreferencePage implements
		IWorkbenchPreferencePage {

	public PrismPreferencePage() {
		super(GRID);
		setPreferenceStore(Activator.getDefault().getPreferenceStore());
		setDescription("Prism Model Checker preferences.");
	}

	@Override
	protected void createFieldEditors() {
		addField(new FileFieldEditor(PreferenceConstants.PRISM_EXECUTABLE, 
				PreferenceConstants.PRISM_EXECUTABLE_LABEL, getFieldEditorParent()));
	}

	@Override
	public void init(IWorkbench workbench) {
		// Nothing to do here
	}

}
